/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.transformers.inbound;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import uk.gov.ida.saml.core.domain.DetailedStatusCode;
import uk.gov.ida.saml.hub.domain.IdpIdaStatus;

public class SamlStatusToIdpIdaStatusMappingsFactory {
    private static boolean isKnownNoAuthenticationContextDetail(String value) {
        return value.equals("authn-cancel") || value.equals("loa-pending") || value.equals("uplift-failed");
    }

    public static Map<SamlStatusDefinitions, IdpIdaStatus.Status> getSamlToIdpIdaStatusMappings() {
        return Map.of(SamlStatusDefinitions.Success, IdpIdaStatus.Status.Success, SamlStatusDefinitions.AuthenticationCancelled, IdpIdaStatus.Status.AuthenticationCancelled, SamlStatusDefinitions.AuthenticationPending, IdpIdaStatus.Status.AuthenticationPending, SamlStatusDefinitions.UpliftFailed, IdpIdaStatus.Status.UpliftFailed, SamlStatusDefinitions.NoAuthenticationContext, IdpIdaStatus.Status.NoAuthenticationContext, SamlStatusDefinitions.AuthenticationFailed, IdpIdaStatus.Status.AuthenticationFailed, SamlStatusDefinitions.RequesterErrorFromIdp, IdpIdaStatus.Status.RequesterError, SamlStatusDefinitions.RequesterErrorRequestDeniedFromIdp, IdpIdaStatus.Status.RequesterError);
    }

    static enum SamlStatusDefinitions {
        Success(DetailedStatusCode.Success, v -> true),
        AuthenticationCancelled(DetailedStatusCode.NoAuthenticationContext, "authn-cancel"::equals),
        AuthenticationPending(DetailedStatusCode.NoAuthenticationContext, "loa-pending"::equals),
        NoAuthenticationContext(DetailedStatusCode.NoAuthenticationContext, v -> v == null || !SamlStatusToIdpIdaStatusMappingsFactory.isKnownNoAuthenticationContextDetail(v)),
        AuthenticationFailed(DetailedStatusCode.AuthenticationFailed, v -> true),
        RequesterErrorFromIdp(DetailedStatusCode.RequesterErrorFromIdp, Objects::isNull),
        RequesterErrorRequestDeniedFromIdp(DetailedStatusCode.RequesterErrorRequestDeniedFromIdp, Objects::isNull),
        UpliftFailed(DetailedStatusCode.NoAuthenticationContext, "uplift-failed"::equals);

        private final DetailedStatusCode statusCode;
        private final Predicate<String> statusDetailValuePredicate;

        private SamlStatusDefinitions(DetailedStatusCode statusCode, Predicate<String> statusDetailValuePredicate) {
            this.statusCode = statusCode;
            this.statusDetailValuePredicate = statusDetailValuePredicate;
        }

        public boolean matches(String samlStatusValue, Optional<String> samlSubStatusValue, List<String> statusDetailValues) {
            boolean statusCodesMatch = this.statusCode.getStatus().equals(samlStatusValue) && this.statusCode.getSubStatus().equals(samlSubStatusValue);
            boolean statusDetailsMatch = statusDetailValues.isEmpty() ? this.statusDetailValuePredicate.test(null) : statusDetailValues.stream().anyMatch(this.statusDetailValuePredicate);
            return statusCodesMatch && statusDetailsMatch;
        }
    }
}

