/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.transformers.outbound;

import com.google.inject.Inject;
import java.util.function.Function;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.hub.domain.MatchingServiceHealthCheckRequest;

public class MatchingServiceHealthCheckRequestToSamlAttributeQueryTransformer
implements Function<MatchingServiceHealthCheckRequest, AttributeQuery> {
    private final OpenSamlXmlObjectFactory samlObjectFactory;

    @Inject
    public MatchingServiceHealthCheckRequestToSamlAttributeQueryTransformer(OpenSamlXmlObjectFactory samlObjectFactory) {
        this.samlObjectFactory = samlObjectFactory;
    }

    @Override
    public AttributeQuery apply(MatchingServiceHealthCheckRequest originalQuery) {
        AttributeQuery transformedQuery = this.samlObjectFactory.createAttributeQuery();
        Issuer issuer = this.samlObjectFactory.createIssuer(originalQuery.getIssuer());
        transformedQuery.setID(originalQuery.getId());
        transformedQuery.setIssuer(issuer);
        transformedQuery.setIssueInstant(DateTime.now());
        Subject subject = this.samlObjectFactory.createSubject();
        NameID nameId = this.samlObjectFactory.createNameId(originalQuery.getPersistentId().getNameId());
        nameId.setSPNameQualifier(originalQuery.getAuthnRequestIssuerEntityId());
        nameId.setNameQualifier(originalQuery.getAssertionConsumerServiceUrl().toASCIIString());
        subject.setNameID(nameId);
        SubjectConfirmation subjectConfirmation = this.samlObjectFactory.createSubjectConfirmation();
        SubjectConfirmationData subjectConfirmationData = this.samlObjectFactory.createSubjectConfirmationData();
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        subject.getSubjectConfirmations().add(subjectConfirmation);
        transformedQuery.setSubject(subject);
        return transformedQuery;
    }
}

