/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.transformers.outbound;

import javax.inject.Inject;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.domain.IdaStatus;
import uk.gov.ida.saml.core.domain.OutboundResponseFromHub;
import uk.gov.ida.saml.core.transformers.outbound.IdaResponseToSamlResponseTransformer;
import uk.gov.ida.saml.hub.transformers.outbound.EncryptedAssertionUnmarshaller;
import uk.gov.ida.saml.hub.transformers.outbound.SimpleProfileTransactionIdaStatusMarshaller;

public class SimpleProfileOutboundResponseFromHubToSamlResponseTransformer
extends IdaResponseToSamlResponseTransformer<OutboundResponseFromHub> {
    private final SimpleProfileTransactionIdaStatusMarshaller statusMarshaller;
    private final EncryptedAssertionUnmarshaller encryptedAssertionUnmarshaller;

    @Inject
    public SimpleProfileOutboundResponseFromHubToSamlResponseTransformer(SimpleProfileTransactionIdaStatusMarshaller statusMarshaller, OpenSamlXmlObjectFactory openSamlXmlObjectFactory, EncryptedAssertionUnmarshaller encryptedAssertionUnmarshaller) {
        super(openSamlXmlObjectFactory);
        this.statusMarshaller = statusMarshaller;
        this.encryptedAssertionUnmarshaller = encryptedAssertionUnmarshaller;
    }

    protected void transformAssertions(OutboundResponseFromHub originalResponse, Response transformedResponse) {
        originalResponse.getEncryptedAssertions().stream().map(this.encryptedAssertionUnmarshaller::transform).forEach(transformedResponse.getEncryptedAssertions()::add);
    }

    protected Status transformStatus(OutboundResponseFromHub originalResponse) {
        return this.statusMarshaller.toSamlStatus((IdaStatus)originalResponse.getStatus());
    }

    protected void transformDestination(OutboundResponseFromHub originalResponse, Response transformedResponse) {
        transformedResponse.setDestination(originalResponse.getDestination().toASCIIString());
    }

    protected void transformIssuer(OutboundResponseFromHub originalResponse, Response transformedResponse) {
    }
}

