/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.transformers.outbound.providers;

import java.util.function.Function;
import javax.inject.Inject;
import org.opensaml.saml.saml2.core.Response;
import uk.gov.ida.saml.core.transformers.outbound.decorators.ResponseAssertionSigner;
import uk.gov.ida.saml.core.transformers.outbound.decorators.SamlResponseAssertionEncrypter;
import uk.gov.ida.saml.serializers.XmlObjectToBase64EncodedStringTransformer;

public class ResponseToUnsignedStringTransformer
implements Function<Response, String> {
    protected final XmlObjectToBase64EncodedStringTransformer<Response> xmlObjectToBase64EncodedStringTransformer;
    protected final ResponseAssertionSigner responseAssertionSigner;
    protected final SamlResponseAssertionEncrypter assertionEncrypter;

    @Inject
    public ResponseToUnsignedStringTransformer(XmlObjectToBase64EncodedStringTransformer<Response> xmlObjectToBase64EncodedStringTransformer, ResponseAssertionSigner responseAssertionSigner, SamlResponseAssertionEncrypter assertionEncrypter) {
        this.xmlObjectToBase64EncodedStringTransformer = xmlObjectToBase64EncodedStringTransformer;
        this.responseAssertionSigner = responseAssertionSigner;
        this.assertionEncrypter = assertionEncrypter;
    }

    @Override
    public String apply(Response response) {
        Response signedResponse = this.responseAssertionSigner.signAssertions(response);
        Response signedEncryptedResponse = (Response)this.assertionEncrypter.encryptAssertions((Object)signedResponse);
        return (String)this.xmlObjectToBase64EncodedStringTransformer.apply((Object)signedEncryptedResponse);
    }
}

