/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.validators.authnrequest;

import com.google.common.base.Strings;
import org.joda.time.DateTime;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.xmlsec.signature.Signature;
import uk.gov.ida.saml.core.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.core.validation.SamlTransformationErrorException;
import uk.gov.ida.saml.core.validation.SamlTransformationErrorManager;
import uk.gov.ida.saml.core.validation.SamlValidationSpecificationFailure;
import uk.gov.ida.saml.core.validators.SamlValidator;
import uk.gov.ida.saml.hub.exception.SamlDuplicateRequestIdException;
import uk.gov.ida.saml.hub.exception.SamlRequestTooOldException;
import uk.gov.ida.saml.hub.validators.authnrequest.AuthnRequestIssueInstantValidator;
import uk.gov.ida.saml.hub.validators.authnrequest.DuplicateAuthnRequestValidator;
import uk.gov.ida.saml.security.validators.issuer.IssuerValidator;
import uk.gov.ida.saml.security.validators.signature.SamlSignatureUtil;

public class AuthnRequestFromTransactionValidator
implements SamlValidator<AuthnRequest> {
    private final IssuerValidator issuerValidator;
    private final DuplicateAuthnRequestValidator duplicateAuthnRequestValidator;
    private final AuthnRequestIssueInstantValidator issueInstantValidator;

    public AuthnRequestFromTransactionValidator(IssuerValidator issuerValidator, DuplicateAuthnRequestValidator duplicateAuthnRequestValidator, AuthnRequestIssueInstantValidator issueInstantValidator) {
        this.issuerValidator = issuerValidator;
        this.duplicateAuthnRequestValidator = duplicateAuthnRequestValidator;
        this.issueInstantValidator = issueInstantValidator;
    }

    @Override
    public void validate(AuthnRequest request) {
        this.issuerValidator.validate(request.getIssuer());
        this.validateRequestId(request);
        this.validateIssueInstant(request);
        this.validateSignaturePresence(request);
        this.validateVersion(request);
        this.validateNameIdPolicy(request);
        this.validateScoping(request);
        this.validateProtocolBinding(request);
        this.validatePassiveXSBoolean(request);
    }

    private void validateScoping(AuthnRequest request) {
        if (request.getScoping() != null) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.scopingNotAllowed();
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
    }

    private void validatePassiveXSBoolean(AuthnRequest request) {
        if (request.isPassiveXSBoolean() != null) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.isPassiveNotAllowed();
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
    }

    private void validateRequestId(AuthnRequest request) {
        String requestId = request.getID();
        if (Strings.isNullOrEmpty((String)requestId)) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.missingRequestId();
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        if (!this.requestIdStartsWithUnderscoreOrLetter(requestId)) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.invalidRequestID();
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        if (!this.duplicateAuthnRequestValidator.valid(request.getID())) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.duplicateRequestId((String)request.getID(), (String)request.getIssuer().getValue());
            throw new SamlDuplicateRequestIdException(failure.getErrorMessage(), failure.getLogLevel());
        }
    }

    private boolean requestIdStartsWithUnderscoreOrLetter(String requestId) {
        String firstCharacter = requestId.substring(0, 1);
        return firstCharacter.equals("_") || firstCharacter.matches("[a-zA-Z]");
    }

    private void validateSignaturePresence(AuthnRequest request) {
        Signature signature = request.getSignature();
        if (signature == null) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.missingSignature();
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        if (!SamlSignatureUtil.isSignaturePresent((Signature)signature)) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.signatureNotSigned();
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
    }

    private void validateVersion(AuthnRequest request) {
        String requestId = request.getID();
        if (request.getVersion() == null) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.missingRequestVersion((String)requestId);
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        if (request.getVersion() != SAMLVersion.VERSION_20) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.illegalRequestVersionNumber();
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
    }

    private void validateIssueInstant(AuthnRequest request) {
        String requestId = request.getID();
        DateTime issueInstant = request.getIssueInstant();
        if (issueInstant == null) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.missingRequestIssueInstant((String)requestId);
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        if (!this.issueInstantValidator.isValid(issueInstant)) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.requestTooOld((String)request.getID(), (DateTime)issueInstant, (DateTime)DateTime.now());
            throw new SamlRequestTooOldException(failure.getErrorMessage(), failure.getLogLevel());
        }
    }

    private void validateNameIdPolicy(AuthnRequest request) {
        NameIDPolicy nameIDPolicy = request.getNameIDPolicy();
        if (nameIDPolicy != null) {
            if (nameIDPolicy.getFormat() == null) {
                SamlTransformationErrorManager.warn((SamlValidationSpecificationFailure)SamlTransformationErrorFactory.missingNameIDPolicy());
            } else if (!nameIDPolicy.getFormat().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent")) {
                SamlTransformationErrorManager.warn((SamlValidationSpecificationFailure)SamlTransformationErrorFactory.illegalNameIDPolicy((String)nameIDPolicy.getFormat()));
            }
        }
    }

    private void validateProtocolBinding(AuthnRequest request) {
        String protocolBinding = request.getProtocolBinding();
        if (protocolBinding != null && !protocolBinding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.illegalProtocolBindingError((String)protocolBinding, (String)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
    }
}

