/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.validators.authnrequest;

import com.google.inject.Inject;
import io.dropwizard.util.Duration;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import uk.gov.ida.saml.hub.configuration.SamlAuthnRequestValidityDurationConfiguration;

public class AuthnRequestIssueInstantValidator {
    private final SamlAuthnRequestValidityDurationConfiguration samlAuthnRequestValidityDurationConfiguration;

    @Inject
    public AuthnRequestIssueInstantValidator(SamlAuthnRequestValidityDurationConfiguration samlAuthnRequestValidityDurationConfiguration) {
        this.samlAuthnRequestValidityDurationConfiguration = samlAuthnRequestValidityDurationConfiguration;
    }

    public boolean isValid(DateTime issueInstant) {
        Duration authnRequestValidityDuration = this.samlAuthnRequestValidityDurationConfiguration.getAuthnRequestValidityDuration();
        return !issueInstant.isBefore((ReadableInstant)DateTime.now().minus(authnRequestValidityDuration.toMilliseconds()));
    }
}

