/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.validators.authnrequest;

import com.google.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import uk.gov.ida.saml.hub.configuration.SamlDuplicateRequestValidationConfiguration;
import uk.gov.ida.saml.hub.validators.authnrequest.AuthnRequestIdKey;
import uk.gov.ida.saml.hub.validators.authnrequest.IdExpirationCache;

public class DuplicateAuthnRequestValidator {
    private final IdExpirationCache<AuthnRequestIdKey> previousRequests;
    private final Duration expirationDuration;

    @Inject
    public DuplicateAuthnRequestValidator(IdExpirationCache<AuthnRequestIdKey> previousRequests, SamlDuplicateRequestValidationConfiguration samlDuplicateRequestValidationConfiguration) {
        this.previousRequests = previousRequests;
        this.expirationDuration = Duration.millis((long)samlDuplicateRequestValidationConfiguration.getAuthnRequestIdExpirationDuration().toMilliseconds());
    }

    public boolean valid(String requestId) {
        AuthnRequestIdKey key = new AuthnRequestIdKey(requestId);
        if (this.previousRequests.contains(key) && this.previousRequests.getExpiration(key).isAfterNow()) {
            return false;
        }
        DateTime expire = DateTime.now().plus((ReadableDuration)this.expirationDuration);
        this.previousRequests.setExpiration(key, expire);
        return true;
    }
}

