/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.validators.response.common;

import com.google.common.base.Strings;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Response;
import uk.gov.ida.saml.core.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.hub.exception.SamlValidationException;

public class IssuerValidator {
    public static void validate(Response response) {
        Issuer issuer = response.getIssuer();
        if (issuer == null) {
            throw new SamlValidationException(SamlTransformationErrorFactory.missingIssuer());
        }
        String issuerId = issuer.getValue();
        if (Strings.isNullOrEmpty((String)issuerId)) {
            throw new SamlValidationException(SamlTransformationErrorFactory.emptyIssuer());
        }
        String issuerFormat = issuer.getFormat();
        if (issuerFormat != null && !"urn:oasis:names:tc:SAML:2.0:nameid-format:entity".equals(issuerFormat)) {
            throw new SamlValidationException(SamlTransformationErrorFactory.illegalIssuerFormat((String)issuerFormat, (String)"urn:oasis:names:tc:SAML:2.0:nameid-format:entity"));
        }
    }
}

