/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.validators.response.idp.components;

import org.opensaml.saml.saml2.core.Assertion;
import uk.gov.ida.saml.core.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.core.validation.assertion.IdentityProviderAssertionValidator;
import uk.gov.ida.saml.core.validators.assertion.AuthnStatementAssertionValidator;
import uk.gov.ida.saml.core.validators.assertion.IPAddressValidator;
import uk.gov.ida.saml.core.validators.assertion.MatchingDatasetAssertionValidator;
import uk.gov.ida.saml.hub.exception.SamlValidationException;
import uk.gov.ida.saml.security.validators.ValidatedAssertions;
import uk.gov.ida.saml.security.validators.ValidatedResponse;

public class ResponseAssertionsFromIdpValidator {
    private final IdentityProviderAssertionValidator identityProviderAssertionValidator;
    private final MatchingDatasetAssertionValidator matchingDatasetAssertionValidator;
    private final AuthnStatementAssertionValidator authnStatementAssertionValidator;
    private final IPAddressValidator ipAddressValidator;
    private String hubEntityId;

    public ResponseAssertionsFromIdpValidator(IdentityProviderAssertionValidator assertionValidator, MatchingDatasetAssertionValidator matchingDatasetAssertionValidator, AuthnStatementAssertionValidator authnStatementAssertionValidator, IPAddressValidator ipAddressValidator, String hubEntityId) {
        this.identityProviderAssertionValidator = assertionValidator;
        this.matchingDatasetAssertionValidator = matchingDatasetAssertionValidator;
        this.authnStatementAssertionValidator = authnStatementAssertionValidator;
        this.ipAddressValidator = ipAddressValidator;
        this.hubEntityId = hubEntityId;
    }

    public void validate(ValidatedResponse validatedResponse, ValidatedAssertions validatedAssertions) {
        validatedAssertions.getAssertions().forEach(assertion -> this.identityProviderAssertionValidator.validate(assertion, validatedResponse.getInResponseTo(), this.hubEntityId));
        if (!validatedResponse.isSuccess()) {
            return;
        }
        Assertion matchingDatasetAssertion = this.getMatchingDatasetAssertion(validatedAssertions);
        Assertion authnStatementAssertion = this.getAuthnStatementAssertion(validatedAssertions);
        if (authnStatementAssertion.getAuthnStatements().size() > 1) {
            throw new SamlValidationException(SamlTransformationErrorFactory.multipleAuthnStatements());
        }
        this.matchingDatasetAssertionValidator.validate(matchingDatasetAssertion, validatedResponse.getIssuer().getValue());
        this.authnStatementAssertionValidator.validate(authnStatementAssertion);
        this.identityProviderAssertionValidator.validateConsistency(authnStatementAssertion, matchingDatasetAssertion);
        this.ipAddressValidator.validate(authnStatementAssertion);
    }

    private Assertion getAuthnStatementAssertion(ValidatedAssertions validatedAssertions) {
        return (Assertion)validatedAssertions.getAuthnStatementAssertion().orElseThrow(() -> new SamlValidationException(SamlTransformationErrorFactory.missingAuthnStatement()));
    }

    private Assertion getMatchingDatasetAssertion(ValidatedAssertions validatedAssertions) {
        return (Assertion)validatedAssertions.getMatchingDatasetAssertion().orElseThrow(() -> new SamlValidationException(SamlTransformationErrorFactory.missingMatchingMds()));
    }
}

