/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.validators.response.matchingservice;

import io.prometheus.client.Counter;
import java.util.List;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.metadata.AttributeAuthorityDescriptor;
import uk.gov.ida.saml.core.security.AssertionsDecrypters;
import uk.gov.ida.saml.hub.validators.response.matchingservice.EncryptedResponseFromMatchingServiceValidator;
import uk.gov.ida.saml.hub.validators.response.matchingservice.ResponseAssertionsFromMatchingServiceValidator;
import uk.gov.ida.saml.security.SamlAssertionsSignatureValidator;
import uk.gov.ida.saml.security.validators.ValidatedAssertions;
import uk.gov.ida.saml.security.validators.ValidatedResponse;
import uk.gov.ida.saml.security.validators.signature.SamlResponseSignatureValidator;

public class MatchingServiceResponseValidator {
    private final EncryptedResponseFromMatchingServiceValidator responseFromMatchingServiceValidator;
    private final SamlResponseSignatureValidator samlResponseSignatureValidator;
    private final AssertionsDecrypters assertionsDecrypters;
    private final SamlAssertionsSignatureValidator samlAssertionsSignatureValidator;
    private final ResponseAssertionsFromMatchingServiceValidator responseAssertionsFromMatchingServiceValidator;
    private ValidatedResponse validatedResponse;
    private ValidatedAssertions validatedAssertions;
    private static final Counter msaDecryptionErrorCounter = (Counter)((Counter.Builder)Counter.build((String)"verify_saml_hub_msa_validator_decryption_error_counter", (String)"MSA Decryption error counter, reports number of errors by MSA").labelNames(new String[]{"entityId"})).register();

    public MatchingServiceResponseValidator(EncryptedResponseFromMatchingServiceValidator responseFromMatchingServiceValidator, SamlResponseSignatureValidator samlResponseSignatureValidator, AssertionsDecrypters assertionsDecrypters, SamlAssertionsSignatureValidator samlAssertionsSignatureValidator, ResponseAssertionsFromMatchingServiceValidator responseAssertionsFromMatchingServiceValidator) {
        this.responseFromMatchingServiceValidator = responseFromMatchingServiceValidator;
        this.samlResponseSignatureValidator = samlResponseSignatureValidator;
        this.assertionsDecrypters = assertionsDecrypters;
        this.samlAssertionsSignatureValidator = samlAssertionsSignatureValidator;
        this.responseAssertionsFromMatchingServiceValidator = responseAssertionsFromMatchingServiceValidator;
    }

    public ValidatedResponse getValidatedResponse() {
        return this.validatedResponse;
    }

    public ValidatedAssertions getValidatedAssertions() {
        return this.validatedAssertions;
    }

    public void validate(Response response) {
        this.responseFromMatchingServiceValidator.validate(response);
        this.validatedResponse = this.samlResponseSignatureValidator.validate(response, AttributeAuthorityDescriptor.DEFAULT_ELEMENT_NAME);
        List<Assertion> decryptedAssertions = this.assertionsDecrypters.decryptedAssertions(this.validatedResponse, msaDecryptionErrorCounter, MatchingServiceResponseValidator.class);
        this.validatedAssertions = this.samlAssertionsSignatureValidator.validate(decryptedAssertions, AttributeAuthorityDescriptor.DEFAULT_ELEMENT_NAME);
        this.responseAssertionsFromMatchingServiceValidator.validate(this.validatedResponse, this.validatedAssertions);
    }
}

