/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.metadata;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.signature.X509Certificate;
import uk.gov.ida.saml.metadata.exceptions.NoKeyConfiguredForEntityException;
import uk.gov.ida.saml.security.SigningKeyStore;

@Deprecated
public class IdpMetadataPublicKeyStore
implements SigningKeyStore {
    private final MetadataResolver metadataResolver;

    @Inject
    public IdpMetadataPublicKeyStore(MetadataResolver metadataResolver) {
        this.metadataResolver = metadataResolver;
    }

    public List<PublicKey> getVerifyingKeysForEntity(String entityId) {
        List<PublicKey> publicKeys;
        Optional<EntityDescriptor> entityDescriptor = this.getEntityDescriptor(entityId);
        if (entityDescriptor.isPresent() && !(publicKeys = this.getPublicKeys(entityDescriptor.get(), UsageType.SIGNING)).isEmpty()) {
            return publicKeys;
        }
        throw new NoKeyConfiguredForEntityException(entityId);
    }

    private List<PublicKey> getPublicKeys(EntityDescriptor entityDescriptor, UsageType keyType) {
        return Optional.ofNullable(entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol")).map(descriptor -> this.getPublicKeys((IDPSSODescriptor)descriptor, keyType)).orElse(Collections.emptyList());
    }

    private List<PublicKey> getPublicKeys(IDPSSODescriptor descriptor, UsageType keyType) {
        return descriptor.getKeyDescriptors().stream().filter(keyDescriptor -> keyDescriptor.getUse().equals((Object)keyType)).flatMap(this::getPublicKeys).collect(Collectors.collectingAndThen(Collectors.toList(), List::copyOf));
    }

    private Stream<PublicKey> getPublicKeys(KeyDescriptor keyDescriptor) {
        return keyDescriptor.getKeyInfo().getX509Datas().stream().flatMap(x -> x.getX509Certificates().stream()).map(this::getPublicKey);
    }

    private PublicKey getPublicKey(X509Certificate x509Certificate) {
        try {
            byte[] derValue = Base64.decode((String)x509Certificate.getValue());
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(derValue));
            return certificate.getPublicKey();
        }
        catch (CertificateException | Base64DecodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Optional<EntityDescriptor> getEntityDescriptor(String entityId) {
        try {
            CriteriaSet criteria = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityId)});
            return Optional.ofNullable((EntityDescriptor)this.metadataResolver.resolveSingle((Object)criteria));
        }
        catch (ResolverException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

