/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.transformers;

import java.util.Optional;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import uk.gov.ida.saml.core.domain.AssertionRestrictions;
import uk.gov.ida.saml.core.domain.IdentityProviderAssertion;
import uk.gov.ida.saml.core.domain.IdentityProviderAuthnStatement;
import uk.gov.ida.saml.core.domain.MatchingDataset;
import uk.gov.ida.saml.core.domain.PersistentId;
import uk.gov.ida.saml.core.transformers.IdentityProviderAuthnStatementUnmarshaller;
import uk.gov.ida.saml.core.transformers.VerifyMatchingDatasetUnmarshaller;

public class IdentityProviderAssertionUnmarshaller {
    private final VerifyMatchingDatasetUnmarshaller verifyMatchingDatasetUnmarshaller;
    private final IdentityProviderAuthnStatementUnmarshaller identityProviderAuthnStatementUnmarshaller;
    private final String hubEntityId;

    public IdentityProviderAssertionUnmarshaller(VerifyMatchingDatasetUnmarshaller verifyMatchingDatasetUnmarshaller, IdentityProviderAuthnStatementUnmarshaller identityProviderAuthnStatementUnmarshaller, String hubEntityId) {
        this.verifyMatchingDatasetUnmarshaller = verifyMatchingDatasetUnmarshaller;
        this.identityProviderAuthnStatementUnmarshaller = identityProviderAuthnStatementUnmarshaller;
        this.hubEntityId = hubEntityId;
    }

    public IdentityProviderAssertion fromVerifyAssertion(Assertion assertion) {
        MatchingDataset matchingDataset = null;
        IdentityProviderAuthnStatement authnStatement = null;
        if (this.assertionContainsMatchingDataset(assertion) && !this.containsAuthnStatement(assertion)) {
            matchingDataset = this.verifyMatchingDatasetUnmarshaller.fromAssertion(assertion);
        } else if (this.containsAuthnStatement(assertion) && this.isNotCycle3AssertionFromHub(assertion)) {
            authnStatement = this.identityProviderAuthnStatementUnmarshaller.fromAssertion(assertion);
        }
        return this.getIdentityProviderAssertion(assertion, matchingDataset, authnStatement);
    }

    @Deprecated
    public IdentityProviderAssertion fromAssertion(Assertion assertion) {
        return this.fromVerifyAssertion(assertion);
    }

    private IdentityProviderAssertion getIdentityProviderAssertion(Assertion assertion, MatchingDataset matchingDataset, IdentityProviderAuthnStatement authnStatement) {
        SubjectConfirmationData subjectConfirmationData = ((SubjectConfirmation)assertion.getSubject().getSubjectConfirmations().get(0)).getSubjectConfirmationData();
        AssertionRestrictions assertionRestrictions = new AssertionRestrictions(subjectConfirmationData.getNotOnOrAfter(), subjectConfirmationData.getInResponseTo(), subjectConfirmationData.getRecipient());
        PersistentId persistentId = new PersistentId(assertion.getSubject().getNameID().getValue());
        return new IdentityProviderAssertion(assertion.getID(), assertion.getIssuer().getValue(), assertion.getIssueInstant(), persistentId, assertionRestrictions, Optional.ofNullable(matchingDataset), Optional.ofNullable(authnStatement));
    }

    private boolean assertionContainsMatchingDataset(Assertion assertion) {
        return this.doesAssertionContainAttributes(assertion) && this.isNotCycle3AssertionFromHub(assertion);
    }

    private boolean containsAuthnStatement(Assertion assertion) {
        return !assertion.getAuthnStatements().isEmpty();
    }

    private boolean doesAssertionContainAttributes(Assertion assertion) {
        return !assertion.getAttributeStatements().isEmpty();
    }

    private boolean isNotCycle3AssertionFromHub(Assertion assertion) {
        return !assertion.getIssuer().getValue().equals(this.hubEntityId);
    }
}

