/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.metadata;

import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.ida.common.shared.security.verification.CertificateChainValidator;
import uk.gov.ida.saml.metadata.exception.CertificateConversionException;

public final class CertificateChainValidationFilter
implements MetadataFilter {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateChainValidationFilter.class);
    private final QName role;
    private final CertificateChainValidator certificateChainValidator;
    private final KeyStore keyStore;

    public CertificateChainValidationFilter(@NotNull QName role, @NotNull CertificateChainValidator certificateChainValidator, @NotNull KeyStore keyStore) {
        this.role = role;
        this.certificateChainValidator = certificateChainValidator;
        this.keyStore = keyStore;
    }

    public QName getRole() {
        return this.role;
    }

    public CertificateChainValidator getCertificateChainValidator() {
        return this.certificateChainValidator;
    }

    private KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Nullable
    public XMLObject filter(@Nullable XMLObject metadata) {
        block7: {
            if (metadata == null) {
                return null;
            }
            try {
                if (metadata instanceof EntityDescriptor) {
                    EntityDescriptor entityDescriptor = (EntityDescriptor)metadata;
                    this.filterOutUntrustedRoleDescriptors(entityDescriptor);
                    if (entityDescriptor.getRoleDescriptors().isEmpty()) {
                        LOG.warn("EntityDescriptor '{}' has empty role descriptor list, metadata will be filtered out", (Object)entityDescriptor.getEntityID());
                        return null;
                    }
                    break block7;
                }
                if (metadata instanceof EntitiesDescriptor) {
                    EntitiesDescriptor entitiesDescriptor = (EntitiesDescriptor)metadata;
                    this.filterOutUntrustedEntityDescriptors(entitiesDescriptor);
                    if (entitiesDescriptor.getEntityDescriptors().isEmpty()) {
                        LOG.warn("EntitiesDescriptor '{}' has empty entity descriptor list, metadata will be filtered out");
                        return null;
                    }
                    break block7;
                }
                LOG.error("Internal error, metadata object was of an unsupported type: {}", (Object)metadata.getClass().getName());
                return null;
            }
            catch (CertificateConversionException e) {
                LOG.error("Saw fatal error validating certificate chain, metadata will be filtered out", (Throwable)e);
                return null;
            }
        }
        return metadata;
    }

    private void filterOutUntrustedEntityDescriptors(@Nonnull EntitiesDescriptor entitiesDescriptor) {
        String name = this.getGroupName(entitiesDescriptor);
        LOG.trace("Processing EntitiesDescriptor group: {}", (Object)name);
        HashSet toRemove = new HashSet();
        entitiesDescriptor.getEntityDescriptors().forEach(entityDescriptor -> {
            this.filterOutUntrustedRoleDescriptors((EntityDescriptor)entityDescriptor);
            if (entityDescriptor.getRoleDescriptors().isEmpty()) {
                LOG.warn("EntityDescriptor '{}' has empty role descriptor list, removing from metadata", (Object)entityDescriptor.getEntityID());
                toRemove.add(entityDescriptor);
            }
        });
        if (!toRemove.isEmpty()) {
            entitiesDescriptor.getEntityDescriptors().removeAll(toRemove);
            toRemove.clear();
        }
    }

    private void filterOutUntrustedRoleDescriptors(@Nonnull EntityDescriptor entityDescriptor) {
        String entityID = entityDescriptor.getEntityID();
        LOG.trace("Processing EntityDescriptor: {}", (Object)entityID);
        entityDescriptor.getRoleDescriptors().removeIf(roleDescriptor -> {
            if (this.getRole().equals(roleDescriptor.getElementQName())) {
                this.filterOutUntrustedKeyDescriptors((RoleDescriptor)roleDescriptor);
                if (roleDescriptor.getKeyDescriptors().isEmpty()) {
                    LOG.warn("KeyDescriptor '{}' has empty key descriptor list, removing from metadata", (Object)entityID);
                    return true;
                }
            }
            return false;
        });
    }

    private void filterOutUntrustedKeyDescriptors(@Nonnull RoleDescriptor roleDescriptor) {
        roleDescriptor.getKeyDescriptors().removeIf(keyDescriptor -> {
            KeyInfo keyInfo = keyDescriptor.getKeyInfo();
            try {
                for (X509Certificate certificate : KeyInfoSupport.getCertificates((KeyInfo)keyInfo)) {
                    if (this.getCertificateChainValidator().validate(certificate, this.getKeyStore()).isValid()) continue;
                    LOG.warn("Certificate chain validation failed for metadata entry {}", (Object)certificate.getSubjectDN());
                    return true;
                }
                return false;
            }
            catch (CertificateException e) {
                throw new CertificateConversionException(e);
            }
        });
    }

    private String getGroupName(EntitiesDescriptor group) {
        String name = group.getName();
        if (name != null) {
            return name;
        }
        name = group.getID();
        if (name != null) {
            return name;
        }
        return "(unnamed)";
    }
}

