/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.metadata;

import io.dropwizard.client.JerseyClientConfiguration;
import java.net.URI;
import java.util.Optional;
import uk.gov.ida.saml.metadata.MetadataResolverConfiguration;

public abstract class MetadataConfiguration
implements MetadataResolverConfiguration {
    private URI uri;
    private Long minRefreshDelay;
    private Long maxRefreshDelay;
    private String expectedEntityId;
    private JerseyClientConfiguration client;
    private String jerseyClientName;
    private String hubFederationId;

    public MetadataConfiguration(URI uri, Long minRefreshDelay, Long maxRefreshDelay, String expectedEntityId, JerseyClientConfiguration client, String jerseyClientName, String hubFederationId) {
        this.uri = uri;
        this.minRefreshDelay = Optional.ofNullable(minRefreshDelay).orElse(60000L);
        this.maxRefreshDelay = Optional.ofNullable(maxRefreshDelay).orElse(600000L);
        this.expectedEntityId = Optional.ofNullable(expectedEntityId).orElse("https://signin.service.gov.uk");
        this.client = Optional.ofNullable(client).orElse(new JerseyClientConfiguration());
        this.jerseyClientName = Optional.ofNullable(jerseyClientName).orElse("MetadataClient");
        this.hubFederationId = Optional.ofNullable(hubFederationId).orElse("VERIFY-FEDERATION");
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Long getMinRefreshDelay() {
        return this.minRefreshDelay;
    }

    @Override
    public Long getMaxRefreshDelay() {
        return this.maxRefreshDelay;
    }

    @Override
    public String getExpectedEntityId() {
        return this.expectedEntityId;
    }

    @Override
    public JerseyClientConfiguration getJerseyClientConfiguration() {
        return this.client;
    }

    @Override
    public String getJerseyClientName() {
        return this.jerseyClientName;
    }

    @Override
    public String getHubFederationId() {
        return this.hubFederationId;
    }
}

