/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.metadata;

import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.opensaml.saml.metadata.resolver.filter.impl.SignatureValidationFilter;
import org.opensaml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.security.x509.impl.BasicPKIXValidationInformation;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.SignatureValidationParametersCriterion;
import org.opensaml.xmlsec.signature.support.impl.PKIXSignatureTrustEngine;
import uk.gov.ida.saml.metadata.NamelessPKIXValidationInformationResolver;

public class PKIXSignatureValidationFilterProvider
implements javax.inject.Provider<SignatureValidationFilter> {
    public static final int CERTIFICATE_CHAIN_DEPTH = 0;
    public static final List<String> WHITELISTED_ALGORITHMS = Arrays.asList("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", "http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2001/04/xmlenc#sha512", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", "http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1");
    private KeyStore metadataTrustStore;

    @Inject
    public PKIXSignatureValidationFilterProvider(@Named(value="metadataTruststore") KeyStore metadataTrustStore) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.metadataTrustStore = metadataTrustStore;
    }

    public SignatureValidationFilter get() {
        BasicPKIXValidationInformation basicPKIXValidationInformation = null;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ArrayList<String> aliases = Collections.list(this.metadataTrustStore.aliases());
            ArrayList<X509Certificate> trustAnchors = new ArrayList<X509Certificate>();
            for (String alias : aliases) {
                trustAnchors.add((X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.metadataTrustStore.getCertificate(alias).getEncoded())));
            }
            basicPKIXValidationInformation = new BasicPKIXValidationInformation(trustAnchors, Collections.emptyList(), Integer.valueOf(0));
        }
        catch (KeyStoreException | CertificateException e) {
            Throwables.propagate((Throwable)e);
        }
        PKIXSignatureTrustEngine trustEngine = new PKIXSignatureTrustEngine((PKIXValidationInformationResolver)new NamelessPKIXValidationInformationResolver(Arrays.asList(basicPKIXValidationInformation)), (KeyInfoCredentialResolver)new BasicProviderKeyInfoCredentialResolver(Arrays.asList(new InlineX509DataProvider())));
        SignatureValidationParameters signatureValidationParameters = new SignatureValidationParameters();
        signatureValidationParameters.setWhitelistedAlgorithms(WHITELISTED_ALGORITHMS);
        SignatureValidationFilter validationFilter = new SignatureValidationFilter((SignatureTrustEngine)trustEngine);
        validationFilter.setDefaultCriteria(new CriteriaSet(new Criterion[]{new SignatureValidationParametersCriterion(signatureValidationParameters)}));
        validationFilter.setRequireSignedRoot(true);
        return validationFilter;
    }
}

