/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security;

import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.opensaml.xmlsec.signature.X509Certificate;

public class PublicKeyFactory {
    private final CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");

    public PublicKey create(X509Certificate x509Certificate) {
        try {
            byte[] derValue = Base64.decode((String)x509Certificate.getValue());
            Certificate certificate = this.certificateFactory.generateCertificate(new ByteArrayInputStream(derValue));
            return certificate.getPublicKey();
        }
        catch (CertificateException | Base64DecodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

