/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security.validators;

import java.util.List;
import java.util.Optional;
import org.opensaml.saml.saml2.core.Assertion;

public class ValidatedAssertions {
    private List<Assertion> assertions;

    public ValidatedAssertions(List<Assertion> assertions) {
        this.assertions = assertions;
    }

    public List<Assertion> getAssertions() {
        return this.assertions;
    }

    public Optional<Assertion> getMatchingDatasetAssertion() {
        return this.assertions.stream().filter(this::isMatchingDatasetAssertion).findFirst();
    }

    public Optional<Assertion> getAuthnStatementAssertion() {
        return this.assertions.stream().filter(assertion -> !this.isMatchingDatasetAssertion((Assertion)assertion)).findFirst();
    }

    private boolean isMatchingDatasetAssertion(Assertion assertion) {
        return !assertion.getAttributeStatements().isEmpty() && assertion.getAuthnStatements().isEmpty();
    }
}

