/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.config;

import jakarta.servlet.Filter;
import org.slf4j.MDC;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import uk.gov.justice.laa.crime.filter.mdc.AddLaaTransactionIdToMDC;
import uk.gov.justice.laa.crime.filter.mdc.AfterFilterChainClearDownMDC;

@Configuration
@AutoConfiguration
public class FilterConfiguration {
    private static final String MATCH_ALL_URLS = "/*";

    @Bean
    @ConditionalOnClass(value={MDC.class})
    public FilterRegistrationBean<AddLaaTransactionIdToMDC> addLaaTransactionIdToMDCFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new AddLaaTransactionIdToMDC());
        registrationBean.addUrlPatterns(new String[]{MATCH_ALL_URLS});
        registrationBean.setOrder(Integer.MIN_VALUE);
        return registrationBean;
    }

    @Bean
    @ConditionalOnClass(value={MDC.class})
    public FilterRegistrationBean<AfterFilterChainClearDownMDC> afterFilterChainClearDownMDCFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new AfterFilterChainClearDownMDC());
        registrationBean.addUrlPatterns(new String[]{MATCH_ALL_URLS});
        registrationBean.setOrder(Integer.MAX_VALUE);
        return registrationBean;
    }
}

