/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.constraints.NotNull;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum CourtType {
    MAGISTRATE("MAGISTRATE", "Magistrate"),
    CROWN_COURT("CROWN COURT", "Crown Court");

    @NotNull
    @JsonPropertyDescription(value="This will have the court type of the hardship review")
    private String type;
    private String description;

    @JsonValue
    public String getValue() {
        return this.type;
    }

    public static CourtType getFrom(String status) {
        if (StringUtils.isBlank((CharSequence)status)) {
            return null;
        }
        return Stream.of(CourtType.values()).filter(hrs -> hrs.type.equals(status)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("CourtType with value: %s does not exist.", status)));
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    private CourtType(String type, String description) {
        this.type = type;
        this.description = description;
    }
}

