/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import jakarta.validation.constraints.NotNull;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public enum DecisionReason {
    ABANDONED("ABANDONED", "Abandoned"),
    GRANTED("GRANTED", "Granted"),
    FAILMEANS("FAILMEANS", "Failed the Means Test"),
    FAILIOJ("FAILIOJ", "Failed the IoJ Test"),
    FAILMEIOJ("FAILMEIOJ", "Failed Means and IoJ Tests");

    @NotNull
    @JsonPropertyDescription(value="The decision reason code")
    private final String code;
    private final String description;

    public static DecisionReason getFrom(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return Stream.of(DecisionReason.values()).filter(reason -> reason.code.equals(code)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Decision reason with value: %s does not exist.", code)));
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    private DecisionReason(String code, String description) {
        this.code = code;
        this.description = description;
    }
}

