/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public enum EvidenceFeeLevel {
    LEVEL1("LEVEL1", "Full Fee"),
    LEVEL2("LEVEL2", "Half Fee");

    @JsonPropertyDescription(value="Specifies the Evidence Fee Levels")
    private final String feeLevel;
    private final String description;

    public static EvidenceFeeLevel getFrom(String level) {
        if (StringUtils.isBlank((CharSequence)level)) {
            return null;
        }
        return Stream.of(EvidenceFeeLevel.values()).filter(f -> f.feeLevel.equals(level)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Fee Level with value: %s does not exist.", level)));
    }

    @Generated
    public String getFeeLevel() {
        return this.feeLevel;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    private EvidenceFeeLevel(String feeLevel, String description) {
        this.feeLevel = feeLevel;
        this.description = description;
    }
}

