/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum HardshipReviewDetailCode {
    UNSECURED_LOAN("UNSECURED LOAN", "Unsecured Loan"),
    SECURED_LOAN("SECURED LOAN", "Secured Loan"),
    CAR_LOAN("CAR LOAN", "Car Loan"),
    IVA("IVA", "IVA"),
    CARDS("CARDS", "Credit/Store Card Payment"),
    DEBTS("DEBTS", "Debts"),
    FINES("FINES", "Fines"),
    RENT_ARREARS("RENT ARREARS", "Rent Arrears"),
    BAILIFF("BAILIFF", "Bailiff Costs"),
    DWP_OVERPAYMENT("DWP OVERPAYMENT", "DWP Overpayment"),
    STUDENT_LOAN("STUDENT LOAN", "Student Loan"),
    ADD_MORTGAGE("ADD MORTGAGE", "Mortgage on additional Property"),
    UNI_HOUSING("UNI HOUSING", "University Housing Costs"),
    PRESCRIPTION("PRESCRIPTION", "Prescription Costs"),
    PENSION_PAY("PENSION PAY", "Pension Payments"),
    MEDICAL_COSTS("MEDICAL COSTS", "Medical Costs"),
    OTHER("OTHER", "Other"),
    MEDICAL_GROUNDS("MEDICAL GROUNDS", "Medical Grounds"),
    SUSPENDED_WORK("SUSPENDED WORK", "Suspended from work"),
    OTHER_INC("OTHER INC", "Other");

    @JsonPropertyDescription(value="Hardship review detail codes that are valid")
    @JsonValue
    private final String code;
    private final String description;

    public static HardshipReviewDetailCode getFrom(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return Stream.of(HardshipReviewDetailCode.values()).filter(hrdCode -> hrdCode.code.equals(code)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Hardship review detail code: %s does not exist.", code)));
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    private HardshipReviewDetailCode(String code, String description) {
        this.code = code;
        this.description = description;
    }
}

