/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum HardshipReviewDetailType {
    FUNDING("FUNDING", "Other Sources of Funding"),
    INCOME("INCOME", "Income Denied Access To"),
    EXPENDITURE("EXPENDITURE", "Extra Expenditure"),
    SOL_COSTS("SOL COSTS", "Solicitor Costs"),
    ACTION("ACTION", "Review Progress");

    @JsonPropertyDescription(value="This will have hardship review detail type")
    @JsonValue
    private final String type;
    private final String description;

    public static HardshipReviewDetailType getFrom(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return null;
        }
        return Stream.of(HardshipReviewDetailType.values()).filter(hrd -> hrd.type.equals(type)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("hardship review detail with type: %s does not exist.", type)));
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    private HardshipReviewDetailType(String type, String description) {
        this.type = type;
        this.description = description;
    }
}

