/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum InitAssessmentResult {
    PASS("PASS", "Gross income below the lower threshold"),
    FAIL("FAIL", "Gross income above the upper threshold"),
    HARDSHIP("HARDSHIP APPLICATION", "Hardship application"),
    FULL("FULL", "Gross income in between the upper and lower thresholds");

    private String result;
    private String reason;

    public static InitAssessmentResult getFrom(String result) {
        if (StringUtils.isBlank((CharSequence)result)) {
            return null;
        }
        return Stream.of(InitAssessmentResult.values()).filter(a -> a.result.equals(result)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Initial Assessment Result with value: %s does not exist.", result)));
    }

    @Generated
    public String getResult() {
        return this.result;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    private InitAssessmentResult() {
    }

    @Generated
    private InitAssessmentResult(String result, String reason) {
        this.result = result;
        this.reason = reason;
    }
}

