/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum MagCourtOutcome {
    COMMITTED_FOR_TRIAL("COMMITTED FOR TRIAL", "Committed for Trial"),
    SENT_FOR_TRIAL("SENT FOR TRIAL", "Sent for Trial"),
    RESOLVED_IN_MAGS("RESOLVED IN MAGS", "Resolved in Magistrate Court"),
    COMMITTED("COMMITTED", "Committed for Sentence"),
    APPEAL_TO_CC("APPEAL TO CC", "Appeal to Crown Court");

    @JsonPropertyDescription(value="This will have magistrate court outcome")
    private final String outcome;
    private final String description;

    public static MagCourtOutcome getFrom(String outcome) {
        if (StringUtils.isBlank((CharSequence)outcome)) {
            return null;
        }
        return Stream.of(MagCourtOutcome.values()).filter(mco -> mco.outcome.equals(outcome)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("outcome with value: %s does not exist.", outcome)));
    }

    @Generated
    public String getOutcome() {
        return this.outcome;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    private MagCourtOutcome(String outcome, String description) {
        this.outcome = outcome;
        this.description = description;
    }
}

