/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.filter.mdc;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AddLaaTransactionIdToMDC
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddLaaTransactionIdToMDC.class);
    private static final String LAA_TRANSACTION_ID = "Laa-Transaction-Id";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String laaTransactionIdHeaderValue = this.extractLaaTransactionIdFromHeader(request);
        if (StringUtils.isNotBlank((CharSequence)laaTransactionIdHeaderValue)) {
            log.debug("Adding the {} [{}] to the MDC", (Object)LAA_TRANSACTION_ID, (Object)laaTransactionIdHeaderValue);
            MDC.put((String)LAA_TRANSACTION_ID, (String)laaTransactionIdHeaderValue);
        } else {
            log.debug("Not adding the {} [{}] to the MDC, as it is blank", (Object)LAA_TRANSACTION_ID, (Object)laaTransactionIdHeaderValue);
        }
        chain.doFilter(request, response);
    }

    private String extractLaaTransactionIdFromHeader(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            return httpServletRequest.getHeader(LAA_TRANSACTION_ID);
        }
        return null;
    }
}

