/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.constraints.NotNull;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public enum AssessmentType {
    INIT("INIT"),
    FULL("FULL"),
    PASSPORT("PASSPORT"),
    HARDSHIP("HARDSHIP"),
    MCHARDSHIP("MCHARDSHIP"),
    MEANS_INIT("MEANS_INIT"),
    CCHARDSHIP("CCHARDSHIP"),
    IOJ("IOJ"),
    MEANS_FULL("MEANS_FULL");

    @NotNull
    @JsonPropertyDescription(value="Determines the assessment type")
    private String type;

    @JsonValue
    public String getType() {
        return this.type;
    }

    public static AssessmentType getFrom(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return null;
        }
        return Stream.of(AssessmentType.values()).filter(f -> f.type.equals(type)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Assessment type with value: %s does not exist.", type)));
    }

    @Generated
    private AssessmentType(String type) {
        this.type = type;
    }
}

