/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.constraints.NotNull;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public enum CaseType {
    INDICTABLE("INDICTABLE", "Indictable", Boolean.TRUE),
    SUMMARY_ONLY("SUMMARY ONLY", "Summary-only", Boolean.TRUE),
    CC_ALREADY("CC ALREADY", "Trial already in Crown Court", Boolean.TRUE),
    APPEAL_CC("APPEAL CC", "Appeal to Crown Court", Boolean.FALSE),
    COMMITAL("COMMITAL", "Committal for Sentence", Boolean.TRUE),
    EITHER_WAY("EITHER WAY", "Either-Way", Boolean.FALSE);

    @NotNull
    @JsonPropertyDescription(value="Specifies the case type")
    private final String caseTypeString;
    private final String description;
    private final Boolean mcooOutcomeRequired;

    @JsonValue
    public String getCaseType() {
        return this.caseTypeString;
    }

    public static CaseType getFrom(String caseType) {
        if (StringUtils.isBlank((CharSequence)caseType)) {
            return null;
        }
        return Stream.of(CaseType.values()).filter(f -> f.caseTypeString.equals(caseType)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("CaseType with value: %s does not exist.", caseType)));
    }

    public static boolean isMagsCaseType(String caseType) {
        if (StringUtils.isBlank((CharSequence)caseType)) {
            return false;
        }
        return Set.of(INDICTABLE.getCaseType(), SUMMARY_ONLY.getCaseType(), EITHER_WAY.getCaseType()).contains(caseType);
    }

    @Generated
    public String getCaseTypeString() {
        return this.caseTypeString;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Boolean getMcooOutcomeRequired() {
        return this.mcooOutcomeRequired;
    }

    @Generated
    private CaseType(String caseTypeString, String description, Boolean mcooOutcomeRequired) {
        this.caseTypeString = caseTypeString;
        this.description = description;
        this.mcooOutcomeRequired = mcooOutcomeRequired;
    }
}

