/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import uk.gov.justice.laa.crime.enums.CrownCourtOutcomeType;

public enum CrownCourtOutcome {
    ABANDONED("ABANDONED", CrownCourtOutcomeType.TRIAL.getType(), "Abandoned"),
    AQUITTED("AQUITTED", CrownCourtOutcomeType.TRIAL.getType(), "Acquitted"),
    CONVICTED("CONVICTED", CrownCourtOutcomeType.TRIAL.getType(), "Convicted"),
    DISMISSED("DISMISSED", CrownCourtOutcomeType.TRIAL.getType(), "Dismissed"),
    PART_CONVICTED("PART CONVICTED", CrownCourtOutcomeType.TRIAL.getType(), "Partially Convicted"),
    PART_SUCCESS("PART SUCCESS", CrownCourtOutcomeType.APPEAL.getType(), "Partially Successful"),
    SUCCESSFUL("SUCCESSFUL", CrownCourtOutcomeType.APPEAL.getType(), "Successful"),
    UNSUCCESSFUL("UNSUCCESSFUL", CrownCourtOutcomeType.APPEAL.getType(), "Unsuccessful");

    private final String code;
    private final String type;
    private final String description;

    public static CrownCourtOutcome getFrom(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return Stream.of(CrownCourtOutcome.values()).filter(crownCourtOutcome -> crownCourtOutcome.code.equals(code)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Crown Court Outcome with value: %s does not exist.", code)));
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    private CrownCourtOutcome(String code, String type, String description) {
        this.code = code;
        this.type = type;
        this.description = description;
    }
}

