/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.constraints.NotNull;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public enum CurrentStatus {
    IN_PROGRESS("IN PROGRESS", "Incomplete"),
    COMPLETE("COMPLETE", "Complete");

    @NotNull
    @JsonPropertyDescription(value="This will have the frequency code of the selection")
    private String status;
    private String description;

    public static CurrentStatus getFrom(String status) {
        if (StringUtils.isBlank((CharSequence)status)) {
            throw new IllegalArgumentException(String.format("Status with value: %s does not exist.", status));
        }
        return Stream.of(CurrentStatus.values()).filter(f -> f.status.equals(status)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Status with value: %s does not exist.", status)));
    }

    @JsonValue
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    private CurrentStatus(String status, String description) {
        this.status = status;
        this.description = description;
    }
}

