/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import uk.gov.justice.laa.crime.enums.HardshipReviewDetailType;

public enum DeniedIncomeDetailCode {
    MEDICAL_GROUNDS("MEDICAL GROUNDS", "Medical Grounds", HardshipReviewDetailType.INCOME.getType()),
    SUSPENDED_WORK("SUSPENDED WORK", "Suspended from work", HardshipReviewDetailType.INCOME.getType()),
    OTHER_INC("OTHER INC", "Other", HardshipReviewDetailType.INCOME.getType());

    @JsonPropertyDescription(value="Denied Income detail codes that are valid")
    private final String code;
    private final String description;
    private final String type;

    public static DeniedIncomeDetailCode getFrom(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return Stream.of(DeniedIncomeDetailCode.values()).filter(didCode -> didCode.code.equals(code)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Denied income detail code: %s does not exist.", code)));
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    private DeniedIncomeDetailCode(String code, String description, String type) {
        this.code = code;
        this.description = description;
        this.type = type;
    }
}

