/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public enum EmploymentStatus {
    EMPLOY("EMPLOY", "Employed"),
    SELF("SELF", "Self Employed"),
    SFLF("SFLF", "Crown Court Case"),
    NONPASS("NONPASS", "Unemployed"),
    EMPCDS("EMPCDS", "Employed with SoT"),
    SELF_SOT("SELF-SOT", "Self Employed with SoT"),
    PASSPORTED("PASSPORTED", "Passported Benefits"),
    SELF_CASH("SELF-CASH", "Self Employed - Cash in Hand"),
    EMPLOYED_CASH("EMPLOYED-CASH", "Employed Cash in Hand"),
    YOUTHS_YTH("YOUTHS-YTH", "Youths - Under 18 heard in the Youth court"),
    YOUTHS_MAGS("YOUTHS-MAGS", "Youths - Under 18 heard in the Mags court");

    private final String code;
    private final String description;

    public static EmploymentStatus getFrom(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return Stream.of(EmploymentStatus.values()).filter(status -> status.code.equals(code)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Employment status with value: %s does not exist.", code)));
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    private EmploymentStatus(String code, String description) {
        this.code = code;
        this.description = description;
    }
}

