/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.constraints.NotNull;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public enum Frequency {
    WEEKLY("WEEKLY", "Weekly", 52),
    TWO_WEEKLY("2WEEKLY", "2 Weekly", 26),
    FOUR_WEEKLY("4WEEKLY", "4 Weekly", 13),
    MONTHLY("MONTHLY", "Monthly", 12),
    ANNUALLY("ANNUALLY", "Annually", 1);

    @NotNull
    @JsonPropertyDescription(value="This will have the frequency code of the selection")
    private String code;
    private final String description;
    private int weighting;

    @JsonValue
    public String getCode() {
        return this.code;
    }

    public static Frequency getFrom(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return Stream.of(Frequency.values()).filter(f -> f.code.equals(code)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Frequency with value: %s does not exist.", code)));
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public int getWeighting() {
        return this.weighting;
    }

    @Generated
    private Frequency(String code, String description, int weighting) {
        this.code = code;
        this.description = description;
        this.weighting = weighting;
    }
}

