/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum FullAssessmentResult {
    PASS("PASS", "Disposable income below the threshold"),
    FAIL("FAIL", "Disposable income above the threshold"),
    INEL("INEL", "Refused - Ineligible");

    private String result;
    private String reason;

    public static FullAssessmentResult getFrom(String result) {
        if (StringUtils.isBlank((CharSequence)result)) {
            return null;
        }
        return Stream.of(FullAssessmentResult.values()).filter(a -> a.result.equals(result)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Full Assessment Result with value: %s does not exist.", result)));
    }

    @Generated
    public String getResult() {
        return this.result;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    private FullAssessmentResult() {
    }

    @Generated
    private FullAssessmentResult(String result, String reason) {
        this.result = result;
        this.reason = reason;
    }
}

