/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.constraints.NotNull;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum HardshipReviewStatus {
    IN_PROGRESS("IN PROGRESS", "Incomplete"),
    COMPLETE("COMPLETE", "Complete");

    @NotNull
    @JsonPropertyDescription(value="This will have the status of the hardship review")
    @JsonValue
    private String status;
    private String description;

    @JsonValue
    public String getValue() {
        return this.status;
    }

    public static HardshipReviewStatus getFrom(String status) {
        if (StringUtils.isBlank((CharSequence)status)) {
            return null;
        }
        return Stream.of(HardshipReviewStatus.values()).filter(hrs -> hrs.status.equals(status)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("HardshipReviewStatus with value: %s does not exist.", status)));
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    private HardshipReviewStatus(String status, String description) {
        this.status = status;
        this.description = description;
    }
}

