/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum NewWorkReason {
    PBI("PBI", "ASS", "Crown Court Section 51"),
    PCI("PCI", "ASS", "Crown Court either way offence"),
    FMA("FMA", "ASS", "First Means Assessment"),
    PAI("PAI", "ASS", "Previous Assessment was Incorrect"),
    CFC("CFC", "ASS", "Change in Financial Circumstances"),
    CPS("CPS", "ASS", "Change in Solicitor"),
    HR("HR", "ASS", "Hardship Review (NCT only)"),
    NEW("NEW", "HARDIOJ", "New"),
    PRI("PRI", "HARDIOJ", "Previous Record Incorrect"),
    JR("JR", "HARDIOJ", "Judicial Review"),
    EVI("EVI", "ASS", "Income Evidence Differs from Declaration"),
    INF("INF", "ASS", "Re-assessment Following New Information"),
    CSP("CSP", "ASS", "Change in Partner Status");

    private String code;
    private String type;
    private String description;

    public static NewWorkReason getFrom(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return Stream.of(NewWorkReason.values()).filter(newWorkReason -> newWorkReason.code.equals(code)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("New Work Reason with value: %s does not exist.", code)));
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    private NewWorkReason(String code, String type, String description) {
        this.code = code;
        this.type = type;
        this.description = description;
    }

    private static class NewWorkReasonType {
        private static final String ASS = "ASS";
        private static final String HARDIOJ = "HARDIOJ";

        private NewWorkReasonType() {
        }
    }
}

