/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum RepOrderStatus {
    CURR("CURR", "Current", false, true, 1),
    FI("FI", "Awaiting FI", false, true, 2),
    ERR("ERR", "Created in Error", true, false, 3),
    SUSP("SUSP", "Suspended", false, true, 4),
    NOT_SENT_FOR_TRIAL("NOT SENT FOR TRIAL", "Not sent for trial", false, true, 5);

    private final String code;
    private final String description;
    private final boolean removeContribs;
    private final boolean updateAllowed;
    private final int sequence;

    public static RepOrderStatus getFrom(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return Stream.of(RepOrderStatus.values()).filter(crownCourtOutcome -> crownCourtOutcome.code.equals(code)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Rep Order Status with value: %s does not exist.", code)));
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isRemoveContribs() {
        return this.removeContribs;
    }

    @Generated
    public boolean isUpdateAllowed() {
        return this.updateAllowed;
    }

    @Generated
    public int getSequence() {
        return this.sequence;
    }

    @Generated
    private RepOrderStatus(String code, String description, boolean removeContribs, boolean updateAllowed, int sequence) {
        this.code = code;
        this.description = description;
        this.removeContribs = removeContribs;
        this.updateAllowed = updateAllowed;
        this.sequence = sequence;
    }
}

