/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import jakarta.validation.constraints.NotNull;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public enum ReviewResult {
    PASS("PASS"),
    FAIL("FAIL");

    @NotNull
    @JsonPropertyDescription(value="The review result")
    private final String result;

    public static ReviewResult getFrom(String result) {
        if (StringUtils.isBlank((CharSequence)result)) {
            return null;
        }
        return Stream.of(ReviewResult.values()).filter(reviewResult -> reviewResult.result.equals(result)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Review result with value: %s does not exist.", result)));
    }

    @Generated
    public String getResult() {
        return this.result;
    }

    @Generated
    private ReviewResult(String result) {
        this.result = result;
    }
}

