/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums;

import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum ReviewType {
    ER("ER", "Eligibility Review"),
    EM("EM", "Eligibility Miscalculation Review"),
    NAFI("NAFI", "New Application Following Ineligibility");

    private final String code;
    private final String description;

    public static ReviewType getFrom(String code) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return Stream.of(ReviewType.values()).filter(r -> r.code.equals(code)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("ReviewType with value: %s does not exist.", code)));
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    private ReviewType(String code, String description) {
        this.code = code;
        this.description = description;
    }
}

