/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums.contribution;

import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum TransferStatus {
    ERRATA("ERATA"),
    QUARANTINE("QUARANTINE"),
    REQUESTED("REQUESTED"),
    SENT("SENT"),
    MANUAL("MANUAL"),
    RECEIVED("RECEIVED");

    private static final String EXCEPTION_MESSAGE = "Transfer status with value: %s does not exist";
    private final String value;

    public static TransferStatus getFrom(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return Stream.of(TransferStatus.values()).filter(transferStatus -> transferStatus.value.equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(EXCEPTION_MESSAGE, value)));
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    private TransferStatus(String value) {
        this.value = value;
    }
}

