/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.enums.evidence;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public enum IncomeEvidenceType {
    SIGNATURE("SIGNATURE", "Signature", "Signature", "Llofnod", false),
    CDS15("CDS15", "CDS 15", "CDS 15", "CDS 15", true),
    FREEZING("FREEZING", "Freezing order", "Freezing order", "Gorchymyn Rhewi", true),
    RESTRAINING("RESTRAINING", "Restraint Order", "Restraint Order", "Gorchymyn Atal", true),
    CONFISCATION("CONFISCATION", "Confiscation order", "Confiscation order", "Gorchymyn Atafaeliad", true),
    OTHER_ADHOC("OTHER_ADHOC", "Other Adhoc", "Other Adhoc", "Ad Hoc eraill", true),
    EMP_LETTER_ADHOC("EMP LETTER ADHOC", "Letter from Employer", "Letter from Employer", "Llythyr o'r cyflogwr", true),
    WAGE_SLIP_ADHOC("WAGE SLIP ADHOC", "Wage Slip", "Wage Slip within past 3 months", "Papur Cyflog o fewn y tri mis diwethaf", true),
    NINO("NINO", "National Insurance Number", "National Insurance Number", "Rhif Yswiriant Cenedlaethol", false),
    ACCOUNTS("ACCOUNTS", "Set of Accounts", "Set of Accounts", "Cyfrifon", false),
    OTHER_BUSINESS("OTHER BUSINESS", "Other Business Records", "Other Business Records", "Cofnodion Busnes eraill", false),
    CASH_BOOK("CASH BOOK", "Cash Book", "Cash Book", "Llyfr Arian", false),
    WAGE_SLIP("WAGE SLIP", "Wage Slip", "Wage Slip within past 3 months", "Papur Cyflog o fewn y tri mis diwethaf", false),
    BANK_STATEMENT("BANK STATEMENT", "Bank Statement", "Bank Statement(s) covering 3 months", "Cyfriflen Banc", false),
    TAX_RETURN("TAX RETURN", "Tax Return", "Tax Return", "Ffurflen Dreth", false),
    EMP_LETTER("EMP LETTER", "Letter from Employer", "Letter from Employer", "Llythyr oddi wrth Gyflogwr", false),
    OTHER("OTHER", "Other Ad-hoc evidence", "Text to be entered", "", false);

    private final String name;
    private final String description;
    private final String letterDescription;
    private final String welshLetterDescription;
    private final boolean isExtra;

    public static IncomeEvidenceType getFrom(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return Stream.of(IncomeEvidenceType.values()).filter(type -> type.name.equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Income Evidence Type with value: %s does not exist.", name)));
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getLetterDescription() {
        return this.letterDescription;
    }

    @Generated
    public String getWelshLetterDescription() {
        return this.welshLetterDescription;
    }

    @Generated
    public boolean isExtra() {
        return this.isExtra;
    }

    @Generated
    private IncomeEvidenceType(String name, String description, String letterDescription, String welshLetterDescription, boolean isExtra) {
        this.name = name;
        this.description = description;
        this.letterDescription = letterDescription;
        this.welshLetterDescription = welshLetterDescription;
        this.isExtra = isExtra;
    }

    private static class Constants {
        public static final String CDS_15 = "CDS 15";
        public static final String LETTER_FROM_EMPLOYER = "Letter from Employer";
        public static final String OTHER_ADHOC = "Other Adhoc";
        public static final String NATIONAL_INSURANCE_NUMBER = "National Insurance Number";
        public static final String CASH_BOOK = "Cash Book";
        public static final String TAX_RETURN = "Tax Return";
        public static final String OTHER_BUSINESS_RECORDS = "Other Business Records";
        public static final String SET_OF_ACCOUNTS = "Set of Accounts";
        public static final String CONFISCATION_ORDER = "Confiscation order";
        public static final String RESTRAINT_ORDER = "Restraint Order";
        public static final String FREEZING_ORDER = "Freezing order";
        public static final String SIGNATURE = "Signature";

        private Constants() {
        }
    }
}

