/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.meansassessment;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import uk.gov.justice.laa.crime.enums.meansassessment.IncomeType;
import uk.gov.justice.laa.crime.meansassessment.Amount;
import uk.gov.justice.laa.crime.meansassessment.FrequencyAmount;

public class Income
implements Amount {
    @JsonProperty(value="income_type")
    @Valid
    @NotNull
    private IncomeType incomeType;
    @Valid
    @NotNull
    @JsonProperty(value="applicant")
    private FrequencyAmount applicant;
    @Valid
    @JsonProperty(value="partner")
    private FrequencyAmount partner;

    @Generated
    public static IncomeBuilder builder() {
        return new IncomeBuilder();
    }

    @Generated
    public IncomeType getIncomeType() {
        return this.incomeType;
    }

    @Override
    @Generated
    public FrequencyAmount getApplicant() {
        return this.applicant;
    }

    @Override
    @Generated
    public FrequencyAmount getPartner() {
        return this.partner;
    }

    @Generated
    public Income(IncomeType incomeType, FrequencyAmount applicant, FrequencyAmount partner) {
        this.incomeType = incomeType;
        this.applicant = applicant;
        this.partner = partner;
    }

    @Generated
    public static class IncomeBuilder {
        @Generated
        private IncomeType incomeType;
        @Generated
        private FrequencyAmount applicant;
        @Generated
        private FrequencyAmount partner;

        @Generated
        IncomeBuilder() {
        }

        @JsonProperty(value="income_type")
        @Generated
        public IncomeBuilder incomeType(IncomeType incomeType) {
            this.incomeType = incomeType;
            return this;
        }

        @JsonProperty(value="applicant")
        @Generated
        public IncomeBuilder applicant(FrequencyAmount applicant) {
            this.applicant = applicant;
            return this;
        }

        @JsonProperty(value="partner")
        @Generated
        public IncomeBuilder partner(FrequencyAmount partner) {
            this.partner = partner;
            return this;
        }

        @Generated
        public Income build() {
            return new Income(this.incomeType, this.applicant, this.partner);
        }

        @Generated
        public String toString() {
            return "Income.IncomeBuilder(incomeType=" + this.incomeType + ", applicant=" + this.applicant + ", partner=" + this.partner + ")";
        }
    }
}

