/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import uk.gov.justice.laa.crime.exception.FileReadException;

public final class FileUtils {
    private static final String ERROR_MESSAGE_FORMAT = "Unable to read file with filePath [%s]";

    public static String readFileToString(String filePath) {
        ClassLoader classLoader = FileUtils.class.getClassLoader();
        URL path = classLoader.getResource(filePath);
        if (path == null) {
            throw new FileReadException(ERROR_MESSAGE_FORMAT.formatted(filePath));
        }
        File file = new File(path.getFile());
        try {
            return org.apache.commons.io.FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new FileReadException(ERROR_MESSAGE_FORMAT.formatted(filePath), e);
        }
    }

    @Generated
    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

