/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.util;

import lombok.Generated;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;

public class RequestBuilderUtils {
    private static final String MOCK_TOKEN = "token";
    private static final String LAA_TRANSACTION_ID = "Laa-Transaction-Id";

    public static MockHttpServletRequestBuilder buildRequestGivenContent(HttpMethod method, String content, String endpointUrl) {
        return RequestBuilderUtils.buildRequestGivenContent(method, content, endpointUrl, true);
    }

    public static MockHttpServletRequestBuilder buildRequestGivenContent(HttpMethod method, String content, String endpointUrl, boolean withAuth) {
        MockHttpServletRequestBuilder requestBuilder = MockMvcRequestBuilders.request((HttpMethod)method, (String)endpointUrl, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(content);
        if (withAuth) {
            requestBuilder.header("Authorization", new Object[]{"Bearer token"});
        }
        return requestBuilder;
    }

    public static MockHttpServletRequestBuilder buildRequest(HttpMethod method, String endpoint) {
        return RequestBuilderUtils.buildRequest(method, endpoint, true);
    }

    public static MockHttpServletRequestBuilder buildRequest(HttpMethod method, String endpoint, boolean withAuth) {
        MockHttpServletRequestBuilder requestBuilder = MockMvcRequestBuilders.request((HttpMethod)method, (String)endpoint, (Object[])new Object[0]);
        if (withAuth) {
            requestBuilder.header("Authorization", new Object[]{"Bearer token"});
        }
        return requestBuilder;
    }

    public static MockHttpServletRequestBuilder buildRequestWithTransactionId(HttpMethod method, String endpoint, boolean withAuth) {
        MockHttpServletRequestBuilder requestBuilder = MockMvcRequestBuilders.request((HttpMethod)method, (String)endpoint, (Object[])new Object[0]).header(LAA_TRANSACTION_ID, new Object[]{"laa-transaction-id"});
        if (withAuth) {
            requestBuilder.header("Authorization", new Object[]{"Bearer token"});
        }
        return requestBuilder;
    }

    public static MockHttpServletRequestBuilder buildRequestWithTransactionIdGivenContent(HttpMethod method, String content, String endpointUrl, boolean withAuth) {
        MockHttpServletRequestBuilder requestBuilder = MockMvcRequestBuilders.request((HttpMethod)method, (String)endpointUrl, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).header(LAA_TRANSACTION_ID, new Object[]{"laa-transaction-id"}).content(content);
        if (withAuth) {
            requestBuilder.header("Authorization", new Object[]{"Bearer token"});
        }
        return requestBuilder;
    }

    @Generated
    private RequestBuilderUtils() {
    }
}

