/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import uk.gov.justice.laa.crime.enums.CrownCourtOutcome;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"outcome", "description", "outcomeType", "dateSet"})
public class ApiCrownCourtOutcome {
    @JsonProperty(value="outcome")
    @JsonPropertyDescription(value="CC Outcome")
    @NotNull
    private CrownCourtOutcome outcome;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="description of outcome")
    private String description;
    @JsonProperty(value="outcomeType")
    @JsonPropertyDescription(value="CC outcome type like Trial or Appeal")
    private String outcomeType;
    @JsonProperty(value="dateSet")
    @JsonPropertyDescription(value="crown court outcome date")
    private LocalDateTime dateSet;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiCrownCourtOutcome() {
    }

    public ApiCrownCourtOutcome(CrownCourtOutcome outcome, String description, String outcomeType, LocalDateTime dateSet) {
        this.outcome = outcome;
        this.description = description;
        this.outcomeType = outcomeType;
        this.dateSet = dateSet;
    }

    @JsonProperty(value="outcome")
    public CrownCourtOutcome getOutcome() {
        return this.outcome;
    }

    @JsonProperty(value="outcome")
    public void setOutcome(CrownCourtOutcome outcome) {
        this.outcome = outcome;
    }

    public ApiCrownCourtOutcome withOutcome(CrownCourtOutcome outcome) {
        this.outcome = outcome;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public ApiCrownCourtOutcome withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="outcomeType")
    public String getOutcomeType() {
        return this.outcomeType;
    }

    @JsonProperty(value="outcomeType")
    public void setOutcomeType(String outcomeType) {
        this.outcomeType = outcomeType;
    }

    public ApiCrownCourtOutcome withOutcomeType(String outcomeType) {
        this.outcomeType = outcomeType;
        return this;
    }

    @JsonProperty(value="dateSet")
    public LocalDateTime getDateSet() {
        return this.dateSet;
    }

    @JsonProperty(value="dateSet")
    public void setDateSet(LocalDateTime dateSet) {
        this.dateSet = dateSet;
    }

    public ApiCrownCourtOutcome withDateSet(LocalDateTime dateSet) {
        this.dateSet = dateSet;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("outcome".equals(name)) {
            if (!(value instanceof CrownCourtOutcome)) {
                throw new IllegalArgumentException("property \"outcome\" is of type \"uk.gov.justice.laa.crime.enums.CrownCourtOutcome\", but got " + value.getClass().toString());
            }
            this.setOutcome((CrownCourtOutcome)value);
            return true;
        }
        if ("description".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"description\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setDescription((String)value);
            return true;
        }
        if ("outcomeType".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"outcomeType\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setOutcomeType((String)value);
            return true;
        }
        if ("dateSet".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"dateSet\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setDateSet((LocalDateTime)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("outcome".equals(name)) {
            return this.getOutcome();
        }
        if ("description".equals(name)) {
            return this.getDescription();
        }
        if ("outcomeType".equals(name)) {
            return this.getOutcomeType();
        }
        if ("dateSet".equals(name)) {
            return this.getDateSet();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiCrownCourtOutcome with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiCrownCourtOutcome.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("outcome");
        sb.append('=');
        sb.append((Object)(this.outcome == null ? "<null>" : this.outcome));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("outcomeType");
        sb.append('=');
        sb.append(this.outcomeType == null ? "<null>" : this.outcomeType);
        sb.append(',');
        sb.append("dateSet");
        sb.append('=');
        sb.append(this.dateSet == null ? "<null>" : this.dateSet);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.outcomeType == null ? 0 : this.outcomeType.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.dateSet == null ? 0 : this.dateSet.hashCode());
        result = result * 31 + (this.outcome == null ? 0 : this.outcome.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiCrownCourtOutcome)) {
            return false;
        }
        ApiCrownCourtOutcome rhs = (ApiCrownCourtOutcome)other;
        return (this.outcomeType == rhs.outcomeType || this.outcomeType != null && this.outcomeType.equals(rhs.outcomeType)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.dateSet == rhs.dateSet || this.dateSet != null && this.dateSet.equals(rhs.dateSet)) && (this.outcome == rhs.outcome || this.outcome != null && this.outcome.equals((Object)rhs.outcome));
    }
}

