/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.contribution;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import uk.gov.justice.laa.crime.enums.AssessmentResult;
import uk.gov.justice.laa.crime.enums.CurrentStatus;
import uk.gov.justice.laa.crime.enums.NewWorkReason;
import uk.gov.justice.laa.crime.enums.contribution.AssessmentType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"assessmentType", "status", "result", "assessmentDate", "newWorkReason"})
public class ApiAssessment {
    @JsonProperty(value="assessmentType")
    @JsonPropertyDescription(value="The type of assessment")
    @Valid
    @NotNull
    private AssessmentType assessmentType;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="The assessment status")
    @Valid
    @NotNull
    private CurrentStatus status;
    @JsonProperty(value="result")
    @JsonPropertyDescription(value="The assessment result")
    @Valid
    @NotNull
    private AssessmentResult result;
    @JsonProperty(value="assessmentDate")
    @JsonPropertyDescription(value="Assessment Date")
    private LocalDateTime assessmentDate;
    @JsonProperty(value="newWorkReason")
    @JsonPropertyDescription(value="New Work Reason")
    private NewWorkReason newWorkReason;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiAssessment() {
    }

    public ApiAssessment(AssessmentType assessmentType, CurrentStatus status, AssessmentResult result, LocalDateTime assessmentDate, NewWorkReason newWorkReason) {
        this.assessmentType = assessmentType;
        this.status = status;
        this.result = result;
        this.assessmentDate = assessmentDate;
        this.newWorkReason = newWorkReason;
    }

    @JsonProperty(value="assessmentType")
    public AssessmentType getAssessmentType() {
        return this.assessmentType;
    }

    @JsonProperty(value="assessmentType")
    public void setAssessmentType(AssessmentType assessmentType) {
        this.assessmentType = assessmentType;
    }

    public ApiAssessment withAssessmentType(AssessmentType assessmentType) {
        this.assessmentType = assessmentType;
        return this;
    }

    @JsonProperty(value="status")
    public CurrentStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(CurrentStatus status) {
        this.status = status;
    }

    public ApiAssessment withStatus(CurrentStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="result")
    public AssessmentResult getResult() {
        return this.result;
    }

    @JsonProperty(value="result")
    public void setResult(AssessmentResult result) {
        this.result = result;
    }

    public ApiAssessment withResult(AssessmentResult result) {
        this.result = result;
        return this;
    }

    @JsonProperty(value="assessmentDate")
    public LocalDateTime getAssessmentDate() {
        return this.assessmentDate;
    }

    @JsonProperty(value="assessmentDate")
    public void setAssessmentDate(LocalDateTime assessmentDate) {
        this.assessmentDate = assessmentDate;
    }

    public ApiAssessment withAssessmentDate(LocalDateTime assessmentDate) {
        this.assessmentDate = assessmentDate;
        return this;
    }

    @JsonProperty(value="newWorkReason")
    public NewWorkReason getNewWorkReason() {
        return this.newWorkReason;
    }

    @JsonProperty(value="newWorkReason")
    public void setNewWorkReason(NewWorkReason newWorkReason) {
        this.newWorkReason = newWorkReason;
    }

    public ApiAssessment withNewWorkReason(NewWorkReason newWorkReason) {
        this.newWorkReason = newWorkReason;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("assessmentType".equals(name)) {
            if (!(value instanceof AssessmentType)) {
                throw new IllegalArgumentException("property \"assessmentType\" is of type \"uk.gov.justice.laa.crime.enums.contribution.AssessmentType\", but got " + value.getClass().toString());
            }
            this.setAssessmentType((AssessmentType)value);
            return true;
        }
        if ("status".equals(name)) {
            if (!(value instanceof CurrentStatus)) {
                throw new IllegalArgumentException("property \"status\" is of type \"uk.gov.justice.laa.crime.enums.CurrentStatus\", but got " + value.getClass().toString());
            }
            this.setStatus((CurrentStatus)value);
            return true;
        }
        if ("result".equals(name)) {
            if (!(value instanceof AssessmentResult)) {
                throw new IllegalArgumentException("property \"result\" is of type \"uk.gov.justice.laa.crime.enums.AssessmentResult\", but got " + value.getClass().toString());
            }
            this.setResult((AssessmentResult)value);
            return true;
        }
        if ("assessmentDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"assessmentDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setAssessmentDate((LocalDateTime)value);
            return true;
        }
        if ("newWorkReason".equals(name)) {
            if (!(value instanceof NewWorkReason)) {
                throw new IllegalArgumentException("property \"newWorkReason\" is of type \"uk.gov.justice.laa.crime.enums.NewWorkReason\", but got " + value.getClass().toString());
            }
            this.setNewWorkReason((NewWorkReason)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("assessmentType".equals(name)) {
            return this.getAssessmentType();
        }
        if ("status".equals(name)) {
            return this.getStatus();
        }
        if ("result".equals(name)) {
            return this.getResult();
        }
        if ("assessmentDate".equals(name)) {
            return this.getAssessmentDate();
        }
        if ("newWorkReason".equals(name)) {
            return this.getNewWorkReason();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiAssessment with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiAssessment.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("assessmentType");
        sb.append('=');
        sb.append((Object)(this.assessmentType == null ? "<null>" : this.assessmentType));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append((Object)(this.status == null ? "<null>" : this.status));
        sb.append(',');
        sb.append("result");
        sb.append('=');
        sb.append((Object)(this.result == null ? "<null>" : this.result));
        sb.append(',');
        sb.append("assessmentDate");
        sb.append('=');
        sb.append(this.assessmentDate == null ? "<null>" : this.assessmentDate);
        sb.append(',');
        sb.append("newWorkReason");
        sb.append('=');
        sb.append((Object)(this.newWorkReason == null ? "<null>" : this.newWorkReason));
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.result == null ? 0 : this.result.hashCode());
        result = result * 31 + (this.assessmentType == null ? 0 : this.assessmentType.hashCode());
        result = result * 31 + (this.assessmentDate == null ? 0 : this.assessmentDate.hashCode());
        result = result * 31 + (this.newWorkReason == null ? 0 : this.newWorkReason.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiAssessment)) {
            return false;
        }
        ApiAssessment rhs = (ApiAssessment)other;
        return (this.result == rhs.result || this.result != null && this.result.equals((Object)rhs.result)) && (this.assessmentType == rhs.assessmentType || this.assessmentType != null && this.assessmentType.equals((Object)rhs.assessmentType)) && (this.assessmentDate == rhs.assessmentDate || this.assessmentDate != null && this.assessmentDate.equals(rhs.assessmentDate)) && (this.newWorkReason == rhs.newWorkReason || this.newWorkReason != null && this.newWorkReason.equals((Object)rhs.newWorkReason)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }
}

