/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.contribution;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"annualDisposableIncome", "disposableIncomePercent", "minimumMonthlyAmount", "contributionCap", "upfrontTotalMonths", "upliftApplied", "upliftedIncomePercent", "minUpliftedMonthlyAmount"})
public class ApiCalculateContributionRequest {
    @JsonProperty(value="annualDisposableIncome")
    @JsonPropertyDescription(value="Annual Disposable Income")
    @NotNull
    private BigDecimal annualDisposableIncome;
    @JsonProperty(value="disposableIncomePercent")
    @JsonPropertyDescription(value="Disposable Income Percent")
    @NotNull
    private BigDecimal disposableIncomePercent;
    @JsonProperty(value="minimumMonthlyAmount")
    @JsonPropertyDescription(value="Minimum Monthly Amount")
    @NotNull
    private BigDecimal minimumMonthlyAmount;
    @JsonProperty(value="contributionCap")
    @JsonPropertyDescription(value="Contribution Cap")
    @NotNull
    private BigDecimal contributionCap;
    @JsonProperty(value="upfrontTotalMonths")
    @JsonPropertyDescription(value="upfront Total Months")
    @NotNull
    private Integer upfrontTotalMonths;
    @JsonProperty(value="upliftApplied")
    @JsonPropertyDescription(value="Currently has a fixed value of 'false'.")
    private Boolean upliftApplied;
    @JsonProperty(value="upliftedIncomePercent")
    @JsonPropertyDescription(value="Uplifted income percent")
    private BigDecimal upliftedIncomePercent;
    @JsonProperty(value="minUpliftedMonthlyAmount")
    @JsonPropertyDescription(value="Minimum Uplifted Monthly Amount")
    private BigDecimal minUpliftedMonthlyAmount;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiCalculateContributionRequest() {
    }

    public ApiCalculateContributionRequest(BigDecimal annualDisposableIncome, BigDecimal disposableIncomePercent, BigDecimal minimumMonthlyAmount, BigDecimal contributionCap, Integer upfrontTotalMonths, Boolean upliftApplied, BigDecimal upliftedIncomePercent, BigDecimal minUpliftedMonthlyAmount) {
        this.annualDisposableIncome = annualDisposableIncome;
        this.disposableIncomePercent = disposableIncomePercent;
        this.minimumMonthlyAmount = minimumMonthlyAmount;
        this.contributionCap = contributionCap;
        this.upfrontTotalMonths = upfrontTotalMonths;
        this.upliftApplied = upliftApplied;
        this.upliftedIncomePercent = upliftedIncomePercent;
        this.minUpliftedMonthlyAmount = minUpliftedMonthlyAmount;
    }

    @JsonProperty(value="annualDisposableIncome")
    public BigDecimal getAnnualDisposableIncome() {
        return this.annualDisposableIncome;
    }

    @JsonProperty(value="annualDisposableIncome")
    public void setAnnualDisposableIncome(BigDecimal annualDisposableIncome) {
        this.annualDisposableIncome = annualDisposableIncome;
    }

    public ApiCalculateContributionRequest withAnnualDisposableIncome(BigDecimal annualDisposableIncome) {
        this.annualDisposableIncome = annualDisposableIncome;
        return this;
    }

    @JsonProperty(value="disposableIncomePercent")
    public BigDecimal getDisposableIncomePercent() {
        return this.disposableIncomePercent;
    }

    @JsonProperty(value="disposableIncomePercent")
    public void setDisposableIncomePercent(BigDecimal disposableIncomePercent) {
        this.disposableIncomePercent = disposableIncomePercent;
    }

    public ApiCalculateContributionRequest withDisposableIncomePercent(BigDecimal disposableIncomePercent) {
        this.disposableIncomePercent = disposableIncomePercent;
        return this;
    }

    @JsonProperty(value="minimumMonthlyAmount")
    public BigDecimal getMinimumMonthlyAmount() {
        return this.minimumMonthlyAmount;
    }

    @JsonProperty(value="minimumMonthlyAmount")
    public void setMinimumMonthlyAmount(BigDecimal minimumMonthlyAmount) {
        this.minimumMonthlyAmount = minimumMonthlyAmount;
    }

    public ApiCalculateContributionRequest withMinimumMonthlyAmount(BigDecimal minimumMonthlyAmount) {
        this.minimumMonthlyAmount = minimumMonthlyAmount;
        return this;
    }

    @JsonProperty(value="contributionCap")
    public BigDecimal getContributionCap() {
        return this.contributionCap;
    }

    @JsonProperty(value="contributionCap")
    public void setContributionCap(BigDecimal contributionCap) {
        this.contributionCap = contributionCap;
    }

    public ApiCalculateContributionRequest withContributionCap(BigDecimal contributionCap) {
        this.contributionCap = contributionCap;
        return this;
    }

    @JsonProperty(value="upfrontTotalMonths")
    public Integer getUpfrontTotalMonths() {
        return this.upfrontTotalMonths;
    }

    @JsonProperty(value="upfrontTotalMonths")
    public void setUpfrontTotalMonths(Integer upfrontTotalMonths) {
        this.upfrontTotalMonths = upfrontTotalMonths;
    }

    public ApiCalculateContributionRequest withUpfrontTotalMonths(Integer upfrontTotalMonths) {
        this.upfrontTotalMonths = upfrontTotalMonths;
        return this;
    }

    @JsonProperty(value="upliftApplied")
    public Boolean getUpliftApplied() {
        return this.upliftApplied;
    }

    @JsonProperty(value="upliftApplied")
    public void setUpliftApplied(Boolean upliftApplied) {
        this.upliftApplied = upliftApplied;
    }

    public ApiCalculateContributionRequest withUpliftApplied(Boolean upliftApplied) {
        this.upliftApplied = upliftApplied;
        return this;
    }

    @JsonProperty(value="upliftedIncomePercent")
    public BigDecimal getUpliftedIncomePercent() {
        return this.upliftedIncomePercent;
    }

    @JsonProperty(value="upliftedIncomePercent")
    public void setUpliftedIncomePercent(BigDecimal upliftedIncomePercent) {
        this.upliftedIncomePercent = upliftedIncomePercent;
    }

    public ApiCalculateContributionRequest withUpliftedIncomePercent(BigDecimal upliftedIncomePercent) {
        this.upliftedIncomePercent = upliftedIncomePercent;
        return this;
    }

    @JsonProperty(value="minUpliftedMonthlyAmount")
    public BigDecimal getMinUpliftedMonthlyAmount() {
        return this.minUpliftedMonthlyAmount;
    }

    @JsonProperty(value="minUpliftedMonthlyAmount")
    public void setMinUpliftedMonthlyAmount(BigDecimal minUpliftedMonthlyAmount) {
        this.minUpliftedMonthlyAmount = minUpliftedMonthlyAmount;
    }

    public ApiCalculateContributionRequest withMinUpliftedMonthlyAmount(BigDecimal minUpliftedMonthlyAmount) {
        this.minUpliftedMonthlyAmount = minUpliftedMonthlyAmount;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("annualDisposableIncome".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"annualDisposableIncome\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setAnnualDisposableIncome((BigDecimal)value);
            return true;
        }
        if ("disposableIncomePercent".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"disposableIncomePercent\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setDisposableIncomePercent((BigDecimal)value);
            return true;
        }
        if ("minimumMonthlyAmount".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"minimumMonthlyAmount\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setMinimumMonthlyAmount((BigDecimal)value);
            return true;
        }
        if ("contributionCap".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"contributionCap\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setContributionCap((BigDecimal)value);
            return true;
        }
        if ("upfrontTotalMonths".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"upfrontTotalMonths\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setUpfrontTotalMonths((Integer)value);
            return true;
        }
        if ("upliftApplied".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"upliftApplied\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setUpliftApplied((Boolean)value);
            return true;
        }
        if ("upliftedIncomePercent".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"upliftedIncomePercent\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setUpliftedIncomePercent((BigDecimal)value);
            return true;
        }
        if ("minUpliftedMonthlyAmount".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"minUpliftedMonthlyAmount\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setMinUpliftedMonthlyAmount((BigDecimal)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("annualDisposableIncome".equals(name)) {
            return this.getAnnualDisposableIncome();
        }
        if ("disposableIncomePercent".equals(name)) {
            return this.getDisposableIncomePercent();
        }
        if ("minimumMonthlyAmount".equals(name)) {
            return this.getMinimumMonthlyAmount();
        }
        if ("contributionCap".equals(name)) {
            return this.getContributionCap();
        }
        if ("upfrontTotalMonths".equals(name)) {
            return this.getUpfrontTotalMonths();
        }
        if ("upliftApplied".equals(name)) {
            return this.getUpliftApplied();
        }
        if ("upliftedIncomePercent".equals(name)) {
            return this.getUpliftedIncomePercent();
        }
        if ("minUpliftedMonthlyAmount".equals(name)) {
            return this.getMinUpliftedMonthlyAmount();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiCalculateContributionRequest with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiCalculateContributionRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("annualDisposableIncome");
        sb.append('=');
        sb.append(this.annualDisposableIncome == null ? "<null>" : this.annualDisposableIncome);
        sb.append(',');
        sb.append("disposableIncomePercent");
        sb.append('=');
        sb.append(this.disposableIncomePercent == null ? "<null>" : this.disposableIncomePercent);
        sb.append(',');
        sb.append("minimumMonthlyAmount");
        sb.append('=');
        sb.append(this.minimumMonthlyAmount == null ? "<null>" : this.minimumMonthlyAmount);
        sb.append(',');
        sb.append("contributionCap");
        sb.append('=');
        sb.append(this.contributionCap == null ? "<null>" : this.contributionCap);
        sb.append(',');
        sb.append("upfrontTotalMonths");
        sb.append('=');
        sb.append(this.upfrontTotalMonths == null ? "<null>" : this.upfrontTotalMonths);
        sb.append(',');
        sb.append("upliftApplied");
        sb.append('=');
        sb.append(this.upliftApplied == null ? "<null>" : this.upliftApplied);
        sb.append(',');
        sb.append("upliftedIncomePercent");
        sb.append('=');
        sb.append(this.upliftedIncomePercent == null ? "<null>" : this.upliftedIncomePercent);
        sb.append(',');
        sb.append("minUpliftedMonthlyAmount");
        sb.append('=');
        sb.append(this.minUpliftedMonthlyAmount == null ? "<null>" : this.minUpliftedMonthlyAmount);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.contributionCap == null ? 0 : this.contributionCap.hashCode());
        result = result * 31 + (this.annualDisposableIncome == null ? 0 : this.annualDisposableIncome.hashCode());
        result = result * 31 + (this.upliftApplied == null ? 0 : this.upliftApplied.hashCode());
        result = result * 31 + (this.minimumMonthlyAmount == null ? 0 : this.minimumMonthlyAmount.hashCode());
        result = result * 31 + (this.minUpliftedMonthlyAmount == null ? 0 : this.minUpliftedMonthlyAmount.hashCode());
        result = result * 31 + (this.upliftedIncomePercent == null ? 0 : this.upliftedIncomePercent.hashCode());
        result = result * 31 + (this.disposableIncomePercent == null ? 0 : this.disposableIncomePercent.hashCode());
        result = result * 31 + (this.upfrontTotalMonths == null ? 0 : this.upfrontTotalMonths.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiCalculateContributionRequest)) {
            return false;
        }
        ApiCalculateContributionRequest rhs = (ApiCalculateContributionRequest)other;
        return (this.contributionCap == rhs.contributionCap || this.contributionCap != null && this.contributionCap.equals(rhs.contributionCap)) && (this.annualDisposableIncome == rhs.annualDisposableIncome || this.annualDisposableIncome != null && this.annualDisposableIncome.equals(rhs.annualDisposableIncome)) && (this.upliftApplied == rhs.upliftApplied || this.upliftApplied != null && this.upliftApplied.equals(rhs.upliftApplied)) && (this.minimumMonthlyAmount == rhs.minimumMonthlyAmount || this.minimumMonthlyAmount != null && this.minimumMonthlyAmount.equals(rhs.minimumMonthlyAmount)) && (this.minUpliftedMonthlyAmount == rhs.minUpliftedMonthlyAmount || this.minUpliftedMonthlyAmount != null && this.minUpliftedMonthlyAmount.equals(rhs.minUpliftedMonthlyAmount)) && (this.upliftedIncomePercent == rhs.upliftedIncomePercent || this.upliftedIncomePercent != null && this.upliftedIncomePercent.equals(rhs.upliftedIncomePercent)) && (this.disposableIncomePercent == rhs.disposableIncomePercent || this.disposableIncomePercent != null && this.disposableIncomePercent.equals(rhs.disposableIncomePercent)) && (this.upfrontTotalMonths == rhs.upfrontTotalMonths || this.upfrontTotalMonths != null && this.upfrontTotalMonths.equals(rhs.upfrontTotalMonths));
    }
}

