/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.contribution;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.common.ApiCrownCourtOutcome;
import uk.gov.justice.laa.crime.common.model.contribution.ApiAssessment;
import uk.gov.justice.laa.crime.enums.AppealType;
import uk.gov.justice.laa.crime.enums.CaseType;
import uk.gov.justice.laa.crime.enums.MagCourtOutcome;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"contributionId", "applicantId", "repId", "effectiveDate", "contributionCap", "monthlyContributions", "upfrontContributions", "dateUpliftApplied", "dateUpliftRemoved", "userCreated", "magCourtOutcome", "caseType", "appealType", "assessments", "removeContributions", "committalDate", "crownCourtOutcome", "disposableIncomeAfterCrownHardship", "disposableIncomeAfterMagHardship", "totalAnnualDisposableIncome"})
public class ApiMaatCalculateContributionRequest {
    @JsonProperty(value="contributionId")
    @JsonPropertyDescription(value="ID")
    private Integer contributionId;
    @JsonProperty(value="applicantId")
    @JsonPropertyDescription(value="The associated applicant ID")
    @NotNull
    private Integer applicantId;
    @JsonProperty(value="repId")
    @JsonPropertyDescription(value="The representation order ID")
    @NotNull
    private Integer repId;
    @JsonProperty(value="effectiveDate")
    @JsonPropertyDescription(value="Effective Date")
    private LocalDateTime effectiveDate;
    @JsonProperty(value="contributionCap")
    @JsonPropertyDescription(value="Contribution Cap")
    private BigDecimal contributionCap;
    @JsonProperty(value="monthlyContributions")
    @JsonPropertyDescription(value="Monthly Contributions")
    private BigDecimal monthlyContributions;
    @JsonProperty(value="upfrontContributions")
    @JsonPropertyDescription(value="Upfront Contributions")
    private BigDecimal upfrontContributions;
    @JsonProperty(value="dateUpliftApplied")
    @JsonPropertyDescription(value="Date Uplift Applied")
    private LocalDateTime dateUpliftApplied;
    @JsonProperty(value="dateUpliftRemoved")
    @JsonPropertyDescription(value="Date Uplift Removed")
    private LocalDateTime dateUpliftRemoved;
    @JsonProperty(value="userCreated")
    @JsonPropertyDescription(value="The user creating the record")
    private String userCreated;
    @JsonProperty(value="magCourtOutcome")
    @JsonPropertyDescription(value="Magistrate Court Outcome")
    @Valid
    private MagCourtOutcome magCourtOutcome;
    @JsonProperty(value="caseType")
    @JsonPropertyDescription(value="The case type")
    @Valid
    @NotNull
    private CaseType caseType;
    @JsonProperty(value="appealType")
    @JsonPropertyDescription(value="The appeal type")
    private AppealType appealType;
    @JsonProperty(value="assessments")
    @JsonPropertyDescription(value="List of assessments performed")
    @Size(min=1)
    @Valid
    @NotNull
    private @Size(min=1) @Valid @NotNull List<ApiAssessment> assessments = new ArrayList<ApiAssessment>();
    @JsonProperty(value="removeContributions")
    @JsonPropertyDescription(value="Indicator to Remove Contributions")
    private String removeContributions;
    @JsonProperty(value="committalDate")
    @JsonPropertyDescription(value="Committal date")
    private LocalDateTime committalDate;
    @JsonProperty(value="crownCourtOutcome")
    @JsonPropertyDescription(value="list of crown court outcome")
    @Valid
    private List<ApiCrownCourtOutcome> crownCourtOutcome = new ArrayList<ApiCrownCourtOutcome>();
    @JsonProperty(value="disposableIncomeAfterCrownHardship")
    @JsonPropertyDescription(value="Disposable Income after Crown Court Hardship Review")
    private BigDecimal disposableIncomeAfterCrownHardship;
    @JsonProperty(value="disposableIncomeAfterMagHardship")
    @JsonPropertyDescription(value="Disposable Income after Mags Court Hardship Review")
    private BigDecimal disposableIncomeAfterMagHardship;
    @JsonProperty(value="totalAnnualDisposableIncome")
    @JsonPropertyDescription(value="Total Annual Disposable Income")
    private BigDecimal totalAnnualDisposableIncome;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiMaatCalculateContributionRequest() {
    }

    public ApiMaatCalculateContributionRequest(Integer contributionId, Integer applicantId, Integer repId, LocalDateTime effectiveDate, BigDecimal contributionCap, BigDecimal monthlyContributions, BigDecimal upfrontContributions, LocalDateTime dateUpliftApplied, LocalDateTime dateUpliftRemoved, String userCreated, MagCourtOutcome magCourtOutcome, CaseType caseType, AppealType appealType, List<ApiAssessment> assessments, String removeContributions, LocalDateTime committalDate, List<ApiCrownCourtOutcome> crownCourtOutcome, BigDecimal disposableIncomeAfterCrownHardship, BigDecimal disposableIncomeAfterMagHardship, BigDecimal totalAnnualDisposableIncome) {
        this.contributionId = contributionId;
        this.applicantId = applicantId;
        this.repId = repId;
        this.effectiveDate = effectiveDate;
        this.contributionCap = contributionCap;
        this.monthlyContributions = monthlyContributions;
        this.upfrontContributions = upfrontContributions;
        this.dateUpliftApplied = dateUpliftApplied;
        this.dateUpliftRemoved = dateUpliftRemoved;
        this.userCreated = userCreated;
        this.magCourtOutcome = magCourtOutcome;
        this.caseType = caseType;
        this.appealType = appealType;
        this.assessments = assessments;
        this.removeContributions = removeContributions;
        this.committalDate = committalDate;
        this.crownCourtOutcome = crownCourtOutcome;
        this.disposableIncomeAfterCrownHardship = disposableIncomeAfterCrownHardship;
        this.disposableIncomeAfterMagHardship = disposableIncomeAfterMagHardship;
        this.totalAnnualDisposableIncome = totalAnnualDisposableIncome;
    }

    @JsonProperty(value="contributionId")
    public Integer getContributionId() {
        return this.contributionId;
    }

    @JsonProperty(value="contributionId")
    public void setContributionId(Integer contributionId) {
        this.contributionId = contributionId;
    }

    public ApiMaatCalculateContributionRequest withContributionId(Integer contributionId) {
        this.contributionId = contributionId;
        return this;
    }

    @JsonProperty(value="applicantId")
    public Integer getApplicantId() {
        return this.applicantId;
    }

    @JsonProperty(value="applicantId")
    public void setApplicantId(Integer applicantId) {
        this.applicantId = applicantId;
    }

    public ApiMaatCalculateContributionRequest withApplicantId(Integer applicantId) {
        this.applicantId = applicantId;
        return this;
    }

    @JsonProperty(value="repId")
    public Integer getRepId() {
        return this.repId;
    }

    @JsonProperty(value="repId")
    public void setRepId(Integer repId) {
        this.repId = repId;
    }

    public ApiMaatCalculateContributionRequest withRepId(Integer repId) {
        this.repId = repId;
        return this;
    }

    @JsonProperty(value="effectiveDate")
    public LocalDateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    @JsonProperty(value="effectiveDate")
    public void setEffectiveDate(LocalDateTime effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public ApiMaatCalculateContributionRequest withEffectiveDate(LocalDateTime effectiveDate) {
        this.effectiveDate = effectiveDate;
        return this;
    }

    @JsonProperty(value="contributionCap")
    public BigDecimal getContributionCap() {
        return this.contributionCap;
    }

    @JsonProperty(value="contributionCap")
    public void setContributionCap(BigDecimal contributionCap) {
        this.contributionCap = contributionCap;
    }

    public ApiMaatCalculateContributionRequest withContributionCap(BigDecimal contributionCap) {
        this.contributionCap = contributionCap;
        return this;
    }

    @JsonProperty(value="monthlyContributions")
    public BigDecimal getMonthlyContributions() {
        return this.monthlyContributions;
    }

    @JsonProperty(value="monthlyContributions")
    public void setMonthlyContributions(BigDecimal monthlyContributions) {
        this.monthlyContributions = monthlyContributions;
    }

    public ApiMaatCalculateContributionRequest withMonthlyContributions(BigDecimal monthlyContributions) {
        this.monthlyContributions = monthlyContributions;
        return this;
    }

    @JsonProperty(value="upfrontContributions")
    public BigDecimal getUpfrontContributions() {
        return this.upfrontContributions;
    }

    @JsonProperty(value="upfrontContributions")
    public void setUpfrontContributions(BigDecimal upfrontContributions) {
        this.upfrontContributions = upfrontContributions;
    }

    public ApiMaatCalculateContributionRequest withUpfrontContributions(BigDecimal upfrontContributions) {
        this.upfrontContributions = upfrontContributions;
        return this;
    }

    @JsonProperty(value="dateUpliftApplied")
    public LocalDateTime getDateUpliftApplied() {
        return this.dateUpliftApplied;
    }

    @JsonProperty(value="dateUpliftApplied")
    public void setDateUpliftApplied(LocalDateTime dateUpliftApplied) {
        this.dateUpliftApplied = dateUpliftApplied;
    }

    public ApiMaatCalculateContributionRequest withDateUpliftApplied(LocalDateTime dateUpliftApplied) {
        this.dateUpliftApplied = dateUpliftApplied;
        return this;
    }

    @JsonProperty(value="dateUpliftRemoved")
    public LocalDateTime getDateUpliftRemoved() {
        return this.dateUpliftRemoved;
    }

    @JsonProperty(value="dateUpliftRemoved")
    public void setDateUpliftRemoved(LocalDateTime dateUpliftRemoved) {
        this.dateUpliftRemoved = dateUpliftRemoved;
    }

    public ApiMaatCalculateContributionRequest withDateUpliftRemoved(LocalDateTime dateUpliftRemoved) {
        this.dateUpliftRemoved = dateUpliftRemoved;
        return this;
    }

    @JsonProperty(value="userCreated")
    public String getUserCreated() {
        return this.userCreated;
    }

    @JsonProperty(value="userCreated")
    public void setUserCreated(String userCreated) {
        this.userCreated = userCreated;
    }

    public ApiMaatCalculateContributionRequest withUserCreated(String userCreated) {
        this.userCreated = userCreated;
        return this;
    }

    @JsonProperty(value="magCourtOutcome")
    public MagCourtOutcome getMagCourtOutcome() {
        return this.magCourtOutcome;
    }

    @JsonProperty(value="magCourtOutcome")
    public void setMagCourtOutcome(MagCourtOutcome magCourtOutcome) {
        this.magCourtOutcome = magCourtOutcome;
    }

    public ApiMaatCalculateContributionRequest withMagCourtOutcome(MagCourtOutcome magCourtOutcome) {
        this.magCourtOutcome = magCourtOutcome;
        return this;
    }

    @JsonProperty(value="caseType")
    public CaseType getCaseType() {
        return this.caseType;
    }

    @JsonProperty(value="caseType")
    public void setCaseType(CaseType caseType) {
        this.caseType = caseType;
    }

    public ApiMaatCalculateContributionRequest withCaseType(CaseType caseType) {
        this.caseType = caseType;
        return this;
    }

    @JsonProperty(value="appealType")
    public AppealType getAppealType() {
        return this.appealType;
    }

    @JsonProperty(value="appealType")
    public void setAppealType(AppealType appealType) {
        this.appealType = appealType;
    }

    public ApiMaatCalculateContributionRequest withAppealType(AppealType appealType) {
        this.appealType = appealType;
        return this;
    }

    @JsonProperty(value="assessments")
    public List<ApiAssessment> getAssessments() {
        return this.assessments;
    }

    @JsonProperty(value="assessments")
    public void setAssessments(List<ApiAssessment> assessments) {
        this.assessments = assessments;
    }

    public ApiMaatCalculateContributionRequest withAssessments(List<ApiAssessment> assessments) {
        this.assessments = assessments;
        return this;
    }

    @JsonProperty(value="removeContributions")
    public String getRemoveContributions() {
        return this.removeContributions;
    }

    @JsonProperty(value="removeContributions")
    public void setRemoveContributions(String removeContributions) {
        this.removeContributions = removeContributions;
    }

    public ApiMaatCalculateContributionRequest withRemoveContributions(String removeContributions) {
        this.removeContributions = removeContributions;
        return this;
    }

    @JsonProperty(value="committalDate")
    public LocalDateTime getCommittalDate() {
        return this.committalDate;
    }

    @JsonProperty(value="committalDate")
    public void setCommittalDate(LocalDateTime committalDate) {
        this.committalDate = committalDate;
    }

    public ApiMaatCalculateContributionRequest withCommittalDate(LocalDateTime committalDate) {
        this.committalDate = committalDate;
        return this;
    }

    @JsonProperty(value="crownCourtOutcome")
    public List<ApiCrownCourtOutcome> getCrownCourtOutcome() {
        return this.crownCourtOutcome;
    }

    @JsonProperty(value="crownCourtOutcome")
    public void setCrownCourtOutcome(List<ApiCrownCourtOutcome> crownCourtOutcome) {
        this.crownCourtOutcome = crownCourtOutcome;
    }

    public ApiMaatCalculateContributionRequest withCrownCourtOutcome(List<ApiCrownCourtOutcome> crownCourtOutcome) {
        this.crownCourtOutcome = crownCourtOutcome;
        return this;
    }

    @JsonProperty(value="disposableIncomeAfterCrownHardship")
    public BigDecimal getDisposableIncomeAfterCrownHardship() {
        return this.disposableIncomeAfterCrownHardship;
    }

    @JsonProperty(value="disposableIncomeAfterCrownHardship")
    public void setDisposableIncomeAfterCrownHardship(BigDecimal disposableIncomeAfterCrownHardship) {
        this.disposableIncomeAfterCrownHardship = disposableIncomeAfterCrownHardship;
    }

    public ApiMaatCalculateContributionRequest withDisposableIncomeAfterCrownHardship(BigDecimal disposableIncomeAfterCrownHardship) {
        this.disposableIncomeAfterCrownHardship = disposableIncomeAfterCrownHardship;
        return this;
    }

    @JsonProperty(value="disposableIncomeAfterMagHardship")
    public BigDecimal getDisposableIncomeAfterMagHardship() {
        return this.disposableIncomeAfterMagHardship;
    }

    @JsonProperty(value="disposableIncomeAfterMagHardship")
    public void setDisposableIncomeAfterMagHardship(BigDecimal disposableIncomeAfterMagHardship) {
        this.disposableIncomeAfterMagHardship = disposableIncomeAfterMagHardship;
    }

    public ApiMaatCalculateContributionRequest withDisposableIncomeAfterMagHardship(BigDecimal disposableIncomeAfterMagHardship) {
        this.disposableIncomeAfterMagHardship = disposableIncomeAfterMagHardship;
        return this;
    }

    @JsonProperty(value="totalAnnualDisposableIncome")
    public BigDecimal getTotalAnnualDisposableIncome() {
        return this.totalAnnualDisposableIncome;
    }

    @JsonProperty(value="totalAnnualDisposableIncome")
    public void setTotalAnnualDisposableIncome(BigDecimal totalAnnualDisposableIncome) {
        this.totalAnnualDisposableIncome = totalAnnualDisposableIncome;
    }

    public ApiMaatCalculateContributionRequest withTotalAnnualDisposableIncome(BigDecimal totalAnnualDisposableIncome) {
        this.totalAnnualDisposableIncome = totalAnnualDisposableIncome;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("contributionId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"contributionId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setContributionId((Integer)value);
            return true;
        }
        if ("applicantId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"applicantId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setApplicantId((Integer)value);
            return true;
        }
        if ("repId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"repId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setRepId((Integer)value);
            return true;
        }
        if ("effectiveDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"effectiveDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setEffectiveDate((LocalDateTime)value);
            return true;
        }
        if ("contributionCap".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"contributionCap\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setContributionCap((BigDecimal)value);
            return true;
        }
        if ("monthlyContributions".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"monthlyContributions\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setMonthlyContributions((BigDecimal)value);
            return true;
        }
        if ("upfrontContributions".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"upfrontContributions\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setUpfrontContributions((BigDecimal)value);
            return true;
        }
        if ("dateUpliftApplied".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"dateUpliftApplied\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setDateUpliftApplied((LocalDateTime)value);
            return true;
        }
        if ("dateUpliftRemoved".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"dateUpliftRemoved\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setDateUpliftRemoved((LocalDateTime)value);
            return true;
        }
        if ("userCreated".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"userCreated\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setUserCreated((String)value);
            return true;
        }
        if ("magCourtOutcome".equals(name)) {
            if (!(value instanceof MagCourtOutcome)) {
                throw new IllegalArgumentException("property \"magCourtOutcome\" is of type \"uk.gov.justice.laa.crime.enums.MagCourtOutcome\", but got " + value.getClass().toString());
            }
            this.setMagCourtOutcome((MagCourtOutcome)value);
            return true;
        }
        if ("caseType".equals(name)) {
            if (!(value instanceof CaseType)) {
                throw new IllegalArgumentException("property \"caseType\" is of type \"uk.gov.justice.laa.crime.enums.CaseType\", but got " + value.getClass().toString());
            }
            this.setCaseType((CaseType)value);
            return true;
        }
        if ("appealType".equals(name)) {
            if (!(value instanceof AppealType)) {
                throw new IllegalArgumentException("property \"appealType\" is of type \"uk.gov.justice.laa.crime.enums.AppealType\", but got " + value.getClass().toString());
            }
            this.setAppealType((AppealType)value);
            return true;
        }
        if ("assessments".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"assessments\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.contribution.ApiAssessment>\", but got " + value.getClass().toString());
            }
            this.setAssessments((List)value);
            return true;
        }
        if ("removeContributions".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"removeContributions\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setRemoveContributions((String)value);
            return true;
        }
        if ("committalDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"committalDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setCommittalDate((LocalDateTime)value);
            return true;
        }
        if ("crownCourtOutcome".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"crownCourtOutcome\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.common.ApiCrownCourtOutcome>\", but got " + value.getClass().toString());
            }
            this.setCrownCourtOutcome((List)value);
            return true;
        }
        if ("disposableIncomeAfterCrownHardship".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"disposableIncomeAfterCrownHardship\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setDisposableIncomeAfterCrownHardship((BigDecimal)value);
            return true;
        }
        if ("disposableIncomeAfterMagHardship".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"disposableIncomeAfterMagHardship\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setDisposableIncomeAfterMagHardship((BigDecimal)value);
            return true;
        }
        if ("totalAnnualDisposableIncome".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"totalAnnualDisposableIncome\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setTotalAnnualDisposableIncome((BigDecimal)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("contributionId".equals(name)) {
            return this.getContributionId();
        }
        if ("applicantId".equals(name)) {
            return this.getApplicantId();
        }
        if ("repId".equals(name)) {
            return this.getRepId();
        }
        if ("effectiveDate".equals(name)) {
            return this.getEffectiveDate();
        }
        if ("contributionCap".equals(name)) {
            return this.getContributionCap();
        }
        if ("monthlyContributions".equals(name)) {
            return this.getMonthlyContributions();
        }
        if ("upfrontContributions".equals(name)) {
            return this.getUpfrontContributions();
        }
        if ("dateUpliftApplied".equals(name)) {
            return this.getDateUpliftApplied();
        }
        if ("dateUpliftRemoved".equals(name)) {
            return this.getDateUpliftRemoved();
        }
        if ("userCreated".equals(name)) {
            return this.getUserCreated();
        }
        if ("magCourtOutcome".equals(name)) {
            return this.getMagCourtOutcome();
        }
        if ("caseType".equals(name)) {
            return this.getCaseType();
        }
        if ("appealType".equals(name)) {
            return this.getAppealType();
        }
        if ("assessments".equals(name)) {
            return this.getAssessments();
        }
        if ("removeContributions".equals(name)) {
            return this.getRemoveContributions();
        }
        if ("committalDate".equals(name)) {
            return this.getCommittalDate();
        }
        if ("crownCourtOutcome".equals(name)) {
            return this.getCrownCourtOutcome();
        }
        if ("disposableIncomeAfterCrownHardship".equals(name)) {
            return this.getDisposableIncomeAfterCrownHardship();
        }
        if ("disposableIncomeAfterMagHardship".equals(name)) {
            return this.getDisposableIncomeAfterMagHardship();
        }
        if ("totalAnnualDisposableIncome".equals(name)) {
            return this.getTotalAnnualDisposableIncome();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiMaatCalculateContributionRequest with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiMaatCalculateContributionRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("contributionId");
        sb.append('=');
        sb.append(this.contributionId == null ? "<null>" : this.contributionId);
        sb.append(',');
        sb.append("applicantId");
        sb.append('=');
        sb.append(this.applicantId == null ? "<null>" : this.applicantId);
        sb.append(',');
        sb.append("repId");
        sb.append('=');
        sb.append(this.repId == null ? "<null>" : this.repId);
        sb.append(',');
        sb.append("effectiveDate");
        sb.append('=');
        sb.append(this.effectiveDate == null ? "<null>" : this.effectiveDate);
        sb.append(',');
        sb.append("contributionCap");
        sb.append('=');
        sb.append(this.contributionCap == null ? "<null>" : this.contributionCap);
        sb.append(',');
        sb.append("monthlyContributions");
        sb.append('=');
        sb.append(this.monthlyContributions == null ? "<null>" : this.monthlyContributions);
        sb.append(',');
        sb.append("upfrontContributions");
        sb.append('=');
        sb.append(this.upfrontContributions == null ? "<null>" : this.upfrontContributions);
        sb.append(',');
        sb.append("dateUpliftApplied");
        sb.append('=');
        sb.append(this.dateUpliftApplied == null ? "<null>" : this.dateUpliftApplied);
        sb.append(',');
        sb.append("dateUpliftRemoved");
        sb.append('=');
        sb.append(this.dateUpliftRemoved == null ? "<null>" : this.dateUpliftRemoved);
        sb.append(',');
        sb.append("userCreated");
        sb.append('=');
        sb.append(this.userCreated == null ? "<null>" : this.userCreated);
        sb.append(',');
        sb.append("magCourtOutcome");
        sb.append('=');
        sb.append((Object)(this.magCourtOutcome == null ? "<null>" : this.magCourtOutcome));
        sb.append(',');
        sb.append("caseType");
        sb.append('=');
        sb.append((Object)(this.caseType == null ? "<null>" : this.caseType));
        sb.append(',');
        sb.append("appealType");
        sb.append('=');
        sb.append((Object)(this.appealType == null ? "<null>" : this.appealType));
        sb.append(',');
        sb.append("assessments");
        sb.append('=');
        sb.append(this.assessments == null ? "<null>" : this.assessments);
        sb.append(',');
        sb.append("removeContributions");
        sb.append('=');
        sb.append(this.removeContributions == null ? "<null>" : this.removeContributions);
        sb.append(',');
        sb.append("committalDate");
        sb.append('=');
        sb.append(this.committalDate == null ? "<null>" : this.committalDate);
        sb.append(',');
        sb.append("crownCourtOutcome");
        sb.append('=');
        sb.append(this.crownCourtOutcome == null ? "<null>" : this.crownCourtOutcome);
        sb.append(',');
        sb.append("disposableIncomeAfterCrownHardship");
        sb.append('=');
        sb.append(this.disposableIncomeAfterCrownHardship == null ? "<null>" : this.disposableIncomeAfterCrownHardship);
        sb.append(',');
        sb.append("disposableIncomeAfterMagHardship");
        sb.append('=');
        sb.append(this.disposableIncomeAfterMagHardship == null ? "<null>" : this.disposableIncomeAfterMagHardship);
        sb.append(',');
        sb.append("totalAnnualDisposableIncome");
        sb.append('=');
        sb.append(this.totalAnnualDisposableIncome == null ? "<null>" : this.totalAnnualDisposableIncome);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.contributionId == null ? 0 : this.contributionId.hashCode());
        result = result * 31 + (this.assessments == null ? 0 : this.assessments.hashCode());
        result = result * 31 + (this.disposableIncomeAfterMagHardship == null ? 0 : this.disposableIncomeAfterMagHardship.hashCode());
        result = result * 31 + (this.upfrontContributions == null ? 0 : this.upfrontContributions.hashCode());
        result = result * 31 + (this.disposableIncomeAfterCrownHardship == null ? 0 : this.disposableIncomeAfterCrownHardship.hashCode());
        result = result * 31 + (this.committalDate == null ? 0 : this.committalDate.hashCode());
        result = result * 31 + (this.removeContributions == null ? 0 : this.removeContributions.hashCode());
        result = result * 31 + (this.userCreated == null ? 0 : this.userCreated.hashCode());
        result = result * 31 + (this.repId == null ? 0 : this.repId.hashCode());
        result = result * 31 + (this.totalAnnualDisposableIncome == null ? 0 : this.totalAnnualDisposableIncome.hashCode());
        result = result * 31 + (this.caseType == null ? 0 : this.caseType.hashCode());
        result = result * 31 + (this.contributionCap == null ? 0 : this.contributionCap.hashCode());
        result = result * 31 + (this.monthlyContributions == null ? 0 : this.monthlyContributions.hashCode());
        result = result * 31 + (this.crownCourtOutcome == null ? 0 : this.crownCourtOutcome.hashCode());
        result = result * 31 + (this.appealType == null ? 0 : this.appealType.hashCode());
        result = result * 31 + (this.dateUpliftRemoved == null ? 0 : this.dateUpliftRemoved.hashCode());
        result = result * 31 + (this.magCourtOutcome == null ? 0 : this.magCourtOutcome.hashCode());
        result = result * 31 + (this.dateUpliftApplied == null ? 0 : this.dateUpliftApplied.hashCode());
        result = result * 31 + (this.applicantId == null ? 0 : this.applicantId.hashCode());
        result = result * 31 + (this.effectiveDate == null ? 0 : this.effectiveDate.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiMaatCalculateContributionRequest)) {
            return false;
        }
        ApiMaatCalculateContributionRequest rhs = (ApiMaatCalculateContributionRequest)other;
        return (this.contributionId == rhs.contributionId || this.contributionId != null && this.contributionId.equals(rhs.contributionId)) && (this.assessments == rhs.assessments || this.assessments != null && this.assessments.equals(rhs.assessments)) && (this.disposableIncomeAfterMagHardship == rhs.disposableIncomeAfterMagHardship || this.disposableIncomeAfterMagHardship != null && this.disposableIncomeAfterMagHardship.equals(rhs.disposableIncomeAfterMagHardship)) && (this.upfrontContributions == rhs.upfrontContributions || this.upfrontContributions != null && this.upfrontContributions.equals(rhs.upfrontContributions)) && (this.disposableIncomeAfterCrownHardship == rhs.disposableIncomeAfterCrownHardship || this.disposableIncomeAfterCrownHardship != null && this.disposableIncomeAfterCrownHardship.equals(rhs.disposableIncomeAfterCrownHardship)) && (this.committalDate == rhs.committalDate || this.committalDate != null && this.committalDate.equals(rhs.committalDate)) && (this.removeContributions == rhs.removeContributions || this.removeContributions != null && this.removeContributions.equals(rhs.removeContributions)) && (this.userCreated == rhs.userCreated || this.userCreated != null && this.userCreated.equals(rhs.userCreated)) && (this.repId == rhs.repId || this.repId != null && this.repId.equals(rhs.repId)) && (this.totalAnnualDisposableIncome == rhs.totalAnnualDisposableIncome || this.totalAnnualDisposableIncome != null && this.totalAnnualDisposableIncome.equals(rhs.totalAnnualDisposableIncome)) && (this.caseType == rhs.caseType || this.caseType != null && this.caseType.equals((Object)rhs.caseType)) && (this.contributionCap == rhs.contributionCap || this.contributionCap != null && this.contributionCap.equals(rhs.contributionCap)) && (this.monthlyContributions == rhs.monthlyContributions || this.monthlyContributions != null && this.monthlyContributions.equals(rhs.monthlyContributions)) && (this.crownCourtOutcome == rhs.crownCourtOutcome || this.crownCourtOutcome != null && this.crownCourtOutcome.equals(rhs.crownCourtOutcome)) && (this.appealType == rhs.appealType || this.appealType != null && this.appealType.equals((Object)rhs.appealType)) && (this.dateUpliftRemoved == rhs.dateUpliftRemoved || this.dateUpliftRemoved != null && this.dateUpliftRemoved.equals(rhs.dateUpliftRemoved)) && (this.magCourtOutcome == rhs.magCourtOutcome || this.magCourtOutcome != null && this.magCourtOutcome.equals((Object)rhs.magCourtOutcome)) && (this.dateUpliftApplied == rhs.dateUpliftApplied || this.dateUpliftApplied != null && this.dateUpliftApplied.equals(rhs.dateUpliftApplied)) && (this.applicantId == rhs.applicantId || this.applicantId != null && this.applicantId.equals(rhs.applicantId)) && (this.effectiveDate == rhs.effectiveDate || this.effectiveDate != null && this.effectiveDate.equals(rhs.effectiveDate));
    }
}

