/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.contribution;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"contributionId", "repId", "effectiveDate", "calcDate", "contributionCap", "monthlyContributions", "upfrontContributions", "upliftApplied", "basedOn", "createContributionOrder", "replacedDate", "ccOutcomeCount", "totalMonths", "processActivity"})
public class ApiMaatCalculateContributionResponse {
    @JsonProperty(value="contributionId")
    @JsonPropertyDescription(value="The ID of the contribution entry")
    private Integer contributionId;
    @JsonProperty(value="repId")
    @JsonPropertyDescription(value="The ID of the representation order")
    private Integer repId;
    @JsonProperty(value="effectiveDate")
    @JsonPropertyDescription(value="The date the current contribution entry was made effective, based on the date set of the last outcome")
    private LocalDateTime effectiveDate;
    @JsonProperty(value="calcDate")
    @JsonPropertyDescription(value="The date the current contribution entry was created")
    private LocalDateTime calcDate;
    @JsonProperty(value="contributionCap")
    @JsonPropertyDescription(value="The cap on contributions")
    private BigDecimal contributionCap;
    @JsonProperty(value="monthlyContributions")
    @JsonPropertyDescription(value="The monthly contribution amount")
    private BigDecimal monthlyContributions;
    @JsonProperty(value="upfrontContributions")
    @JsonPropertyDescription(value="The upfront contribution amount")
    private BigDecimal upfrontContributions;
    @JsonProperty(value="upliftApplied")
    @JsonPropertyDescription(value="Indicates if an income uplift was applied")
    private String upliftApplied;
    @JsonProperty(value="basedOn")
    @JsonPropertyDescription(value="Indicates what the contributions are based on (e.g. Means assessment)")
    private String basedOn;
    @JsonProperty(value="createContributionOrder")
    @JsonPropertyDescription(value="Indicates whether a contribution order should be created")
    private String createContributionOrder;
    @JsonProperty(value="replacedDate")
    @JsonPropertyDescription(value="The date that this contribution entry was replaced")
    private LocalDateTime replacedDate;
    @JsonProperty(value="ccOutcomeCount")
    @JsonPropertyDescription(value="The count of crown court outcomes")
    private Integer ccOutcomeCount;
    @JsonProperty(value="totalMonths")
    @JsonPropertyDescription(value="Total months")
    private Integer totalMonths;
    @JsonProperty(value="processActivity")
    @JsonPropertyDescription(value="Indicator to call MATRIX process activity")
    private Boolean processActivity;
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiMaatCalculateContributionResponse() {
    }

    public ApiMaatCalculateContributionResponse(Integer contributionId, Integer repId, LocalDateTime effectiveDate, LocalDateTime calcDate, BigDecimal contributionCap, BigDecimal monthlyContributions, BigDecimal upfrontContributions, String upliftApplied, String basedOn, String createContributionOrder, LocalDateTime replacedDate, Integer ccOutcomeCount, Integer totalMonths, Boolean processActivity) {
        this.contributionId = contributionId;
        this.repId = repId;
        this.effectiveDate = effectiveDate;
        this.calcDate = calcDate;
        this.contributionCap = contributionCap;
        this.monthlyContributions = monthlyContributions;
        this.upfrontContributions = upfrontContributions;
        this.upliftApplied = upliftApplied;
        this.basedOn = basedOn;
        this.createContributionOrder = createContributionOrder;
        this.replacedDate = replacedDate;
        this.ccOutcomeCount = ccOutcomeCount;
        this.totalMonths = totalMonths;
        this.processActivity = processActivity;
    }

    @JsonProperty(value="contributionId")
    public Integer getContributionId() {
        return this.contributionId;
    }

    @JsonProperty(value="contributionId")
    public void setContributionId(Integer contributionId) {
        this.contributionId = contributionId;
    }

    public ApiMaatCalculateContributionResponse withContributionId(Integer contributionId) {
        this.contributionId = contributionId;
        return this;
    }

    @JsonProperty(value="repId")
    public Integer getRepId() {
        return this.repId;
    }

    @JsonProperty(value="repId")
    public void setRepId(Integer repId) {
        this.repId = repId;
    }

    public ApiMaatCalculateContributionResponse withRepId(Integer repId) {
        this.repId = repId;
        return this;
    }

    @JsonProperty(value="effectiveDate")
    public LocalDateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    @JsonProperty(value="effectiveDate")
    public void setEffectiveDate(LocalDateTime effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public ApiMaatCalculateContributionResponse withEffectiveDate(LocalDateTime effectiveDate) {
        this.effectiveDate = effectiveDate;
        return this;
    }

    @JsonProperty(value="calcDate")
    public LocalDateTime getCalcDate() {
        return this.calcDate;
    }

    @JsonProperty(value="calcDate")
    public void setCalcDate(LocalDateTime calcDate) {
        this.calcDate = calcDate;
    }

    public ApiMaatCalculateContributionResponse withCalcDate(LocalDateTime calcDate) {
        this.calcDate = calcDate;
        return this;
    }

    @JsonProperty(value="contributionCap")
    public BigDecimal getContributionCap() {
        return this.contributionCap;
    }

    @JsonProperty(value="contributionCap")
    public void setContributionCap(BigDecimal contributionCap) {
        this.contributionCap = contributionCap;
    }

    public ApiMaatCalculateContributionResponse withContributionCap(BigDecimal contributionCap) {
        this.contributionCap = contributionCap;
        return this;
    }

    @JsonProperty(value="monthlyContributions")
    public BigDecimal getMonthlyContributions() {
        return this.monthlyContributions;
    }

    @JsonProperty(value="monthlyContributions")
    public void setMonthlyContributions(BigDecimal monthlyContributions) {
        this.monthlyContributions = monthlyContributions;
    }

    public ApiMaatCalculateContributionResponse withMonthlyContributions(BigDecimal monthlyContributions) {
        this.monthlyContributions = monthlyContributions;
        return this;
    }

    @JsonProperty(value="upfrontContributions")
    public BigDecimal getUpfrontContributions() {
        return this.upfrontContributions;
    }

    @JsonProperty(value="upfrontContributions")
    public void setUpfrontContributions(BigDecimal upfrontContributions) {
        this.upfrontContributions = upfrontContributions;
    }

    public ApiMaatCalculateContributionResponse withUpfrontContributions(BigDecimal upfrontContributions) {
        this.upfrontContributions = upfrontContributions;
        return this;
    }

    @JsonProperty(value="upliftApplied")
    public String getUpliftApplied() {
        return this.upliftApplied;
    }

    @JsonProperty(value="upliftApplied")
    public void setUpliftApplied(String upliftApplied) {
        this.upliftApplied = upliftApplied;
    }

    public ApiMaatCalculateContributionResponse withUpliftApplied(String upliftApplied) {
        this.upliftApplied = upliftApplied;
        return this;
    }

    @JsonProperty(value="basedOn")
    public String getBasedOn() {
        return this.basedOn;
    }

    @JsonProperty(value="basedOn")
    public void setBasedOn(String basedOn) {
        this.basedOn = basedOn;
    }

    public ApiMaatCalculateContributionResponse withBasedOn(String basedOn) {
        this.basedOn = basedOn;
        return this;
    }

    @JsonProperty(value="createContributionOrder")
    public String getCreateContributionOrder() {
        return this.createContributionOrder;
    }

    @JsonProperty(value="createContributionOrder")
    public void setCreateContributionOrder(String createContributionOrder) {
        this.createContributionOrder = createContributionOrder;
    }

    public ApiMaatCalculateContributionResponse withCreateContributionOrder(String createContributionOrder) {
        this.createContributionOrder = createContributionOrder;
        return this;
    }

    @JsonProperty(value="replacedDate")
    public LocalDateTime getReplacedDate() {
        return this.replacedDate;
    }

    @JsonProperty(value="replacedDate")
    public void setReplacedDate(LocalDateTime replacedDate) {
        this.replacedDate = replacedDate;
    }

    public ApiMaatCalculateContributionResponse withReplacedDate(LocalDateTime replacedDate) {
        this.replacedDate = replacedDate;
        return this;
    }

    @JsonProperty(value="ccOutcomeCount")
    public Integer getCcOutcomeCount() {
        return this.ccOutcomeCount;
    }

    @JsonProperty(value="ccOutcomeCount")
    public void setCcOutcomeCount(Integer ccOutcomeCount) {
        this.ccOutcomeCount = ccOutcomeCount;
    }

    public ApiMaatCalculateContributionResponse withCcOutcomeCount(Integer ccOutcomeCount) {
        this.ccOutcomeCount = ccOutcomeCount;
        return this;
    }

    @JsonProperty(value="totalMonths")
    public Integer getTotalMonths() {
        return this.totalMonths;
    }

    @JsonProperty(value="totalMonths")
    public void setTotalMonths(Integer totalMonths) {
        this.totalMonths = totalMonths;
    }

    public ApiMaatCalculateContributionResponse withTotalMonths(Integer totalMonths) {
        this.totalMonths = totalMonths;
        return this;
    }

    @JsonProperty(value="processActivity")
    public Boolean getProcessActivity() {
        return this.processActivity;
    }

    @JsonProperty(value="processActivity")
    public void setProcessActivity(Boolean processActivity) {
        this.processActivity = processActivity;
    }

    public ApiMaatCalculateContributionResponse withProcessActivity(Boolean processActivity) {
        this.processActivity = processActivity;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("contributionId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"contributionId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setContributionId((Integer)value);
            return true;
        }
        if ("repId".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"repId\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setRepId((Integer)value);
            return true;
        }
        if ("effectiveDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"effectiveDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setEffectiveDate((LocalDateTime)value);
            return true;
        }
        if ("calcDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"calcDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setCalcDate((LocalDateTime)value);
            return true;
        }
        if ("contributionCap".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"contributionCap\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setContributionCap((BigDecimal)value);
            return true;
        }
        if ("monthlyContributions".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"monthlyContributions\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setMonthlyContributions((BigDecimal)value);
            return true;
        }
        if ("upfrontContributions".equals(name)) {
            if (!(value instanceof BigDecimal)) {
                throw new IllegalArgumentException("property \"upfrontContributions\" is of type \"java.math.BigDecimal\", but got " + value.getClass().toString());
            }
            this.setUpfrontContributions((BigDecimal)value);
            return true;
        }
        if ("upliftApplied".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"upliftApplied\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setUpliftApplied((String)value);
            return true;
        }
        if ("basedOn".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"basedOn\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setBasedOn((String)value);
            return true;
        }
        if ("createContributionOrder".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"createContributionOrder\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setCreateContributionOrder((String)value);
            return true;
        }
        if ("replacedDate".equals(name)) {
            if (!(value instanceof LocalDateTime)) {
                throw new IllegalArgumentException("property \"replacedDate\" is of type \"java.time.LocalDateTime\", but got " + value.getClass().toString());
            }
            this.setReplacedDate((LocalDateTime)value);
            return true;
        }
        if ("ccOutcomeCount".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"ccOutcomeCount\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setCcOutcomeCount((Integer)value);
            return true;
        }
        if ("totalMonths".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"totalMonths\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setTotalMonths((Integer)value);
            return true;
        }
        if ("processActivity".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"processActivity\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setProcessActivity((Boolean)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("contributionId".equals(name)) {
            return this.getContributionId();
        }
        if ("repId".equals(name)) {
            return this.getRepId();
        }
        if ("effectiveDate".equals(name)) {
            return this.getEffectiveDate();
        }
        if ("calcDate".equals(name)) {
            return this.getCalcDate();
        }
        if ("contributionCap".equals(name)) {
            return this.getContributionCap();
        }
        if ("monthlyContributions".equals(name)) {
            return this.getMonthlyContributions();
        }
        if ("upfrontContributions".equals(name)) {
            return this.getUpfrontContributions();
        }
        if ("upliftApplied".equals(name)) {
            return this.getUpliftApplied();
        }
        if ("basedOn".equals(name)) {
            return this.getBasedOn();
        }
        if ("createContributionOrder".equals(name)) {
            return this.getCreateContributionOrder();
        }
        if ("replacedDate".equals(name)) {
            return this.getReplacedDate();
        }
        if ("ccOutcomeCount".equals(name)) {
            return this.getCcOutcomeCount();
        }
        if ("totalMonths".equals(name)) {
            return this.getTotalMonths();
        }
        if ("processActivity".equals(name)) {
            return this.getProcessActivity();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiMaatCalculateContributionResponse with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiMaatCalculateContributionResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("contributionId");
        sb.append('=');
        sb.append(this.contributionId == null ? "<null>" : this.contributionId);
        sb.append(',');
        sb.append("repId");
        sb.append('=');
        sb.append(this.repId == null ? "<null>" : this.repId);
        sb.append(',');
        sb.append("effectiveDate");
        sb.append('=');
        sb.append(this.effectiveDate == null ? "<null>" : this.effectiveDate);
        sb.append(',');
        sb.append("calcDate");
        sb.append('=');
        sb.append(this.calcDate == null ? "<null>" : this.calcDate);
        sb.append(',');
        sb.append("contributionCap");
        sb.append('=');
        sb.append(this.contributionCap == null ? "<null>" : this.contributionCap);
        sb.append(',');
        sb.append("monthlyContributions");
        sb.append('=');
        sb.append(this.monthlyContributions == null ? "<null>" : this.monthlyContributions);
        sb.append(',');
        sb.append("upfrontContributions");
        sb.append('=');
        sb.append(this.upfrontContributions == null ? "<null>" : this.upfrontContributions);
        sb.append(',');
        sb.append("upliftApplied");
        sb.append('=');
        sb.append(this.upliftApplied == null ? "<null>" : this.upliftApplied);
        sb.append(',');
        sb.append("basedOn");
        sb.append('=');
        sb.append(this.basedOn == null ? "<null>" : this.basedOn);
        sb.append(',');
        sb.append("createContributionOrder");
        sb.append('=');
        sb.append(this.createContributionOrder == null ? "<null>" : this.createContributionOrder);
        sb.append(',');
        sb.append("replacedDate");
        sb.append('=');
        sb.append(this.replacedDate == null ? "<null>" : this.replacedDate);
        sb.append(',');
        sb.append("ccOutcomeCount");
        sb.append('=');
        sb.append(this.ccOutcomeCount == null ? "<null>" : this.ccOutcomeCount);
        sb.append(',');
        sb.append("totalMonths");
        sb.append('=');
        sb.append(this.totalMonths == null ? "<null>" : this.totalMonths);
        sb.append(',');
        sb.append("processActivity");
        sb.append('=');
        sb.append(this.processActivity == null ? "<null>" : this.processActivity);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.contributionId == null ? 0 : this.contributionId.hashCode());
        result = result * 31 + (this.upliftApplied == null ? 0 : this.upliftApplied.hashCode());
        result = result * 31 + (this.upfrontContributions == null ? 0 : this.upfrontContributions.hashCode());
        result = result * 31 + (this.calcDate == null ? 0 : this.calcDate.hashCode());
        result = result * 31 + (this.repId == null ? 0 : this.repId.hashCode());
        result = result * 31 + (this.createContributionOrder == null ? 0 : this.createContributionOrder.hashCode());
        result = result * 31 + (this.contributionCap == null ? 0 : this.contributionCap.hashCode());
        result = result * 31 + (this.ccOutcomeCount == null ? 0 : this.ccOutcomeCount.hashCode());
        result = result * 31 + (this.monthlyContributions == null ? 0 : this.monthlyContributions.hashCode());
        result = result * 31 + (this.replacedDate == null ? 0 : this.replacedDate.hashCode());
        result = result * 31 + (this.totalMonths == null ? 0 : this.totalMonths.hashCode());
        result = result * 31 + (this.effectiveDate == null ? 0 : this.effectiveDate.hashCode());
        result = result * 31 + (this.basedOn == null ? 0 : this.basedOn.hashCode());
        result = result * 31 + (this.processActivity == null ? 0 : this.processActivity.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiMaatCalculateContributionResponse)) {
            return false;
        }
        ApiMaatCalculateContributionResponse rhs = (ApiMaatCalculateContributionResponse)other;
        return (this.contributionId == rhs.contributionId || this.contributionId != null && this.contributionId.equals(rhs.contributionId)) && (this.upliftApplied == rhs.upliftApplied || this.upliftApplied != null && this.upliftApplied.equals(rhs.upliftApplied)) && (this.upfrontContributions == rhs.upfrontContributions || this.upfrontContributions != null && this.upfrontContributions.equals(rhs.upfrontContributions)) && (this.calcDate == rhs.calcDate || this.calcDate != null && this.calcDate.equals(rhs.calcDate)) && (this.repId == rhs.repId || this.repId != null && this.repId.equals(rhs.repId)) && (this.createContributionOrder == rhs.createContributionOrder || this.createContributionOrder != null && this.createContributionOrder.equals(rhs.createContributionOrder)) && (this.contributionCap == rhs.contributionCap || this.contributionCap != null && this.contributionCap.equals(rhs.contributionCap)) && (this.ccOutcomeCount == rhs.ccOutcomeCount || this.ccOutcomeCount != null && this.ccOutcomeCount.equals(rhs.ccOutcomeCount)) && (this.monthlyContributions == rhs.monthlyContributions || this.monthlyContributions != null && this.monthlyContributions.equals(rhs.monthlyContributions)) && (this.replacedDate == rhs.replacedDate || this.replacedDate != null && this.replacedDate.equals(rhs.replacedDate)) && (this.totalMonths == rhs.totalMonths || this.totalMonths != null && this.totalMonths.equals(rhs.totalMonths)) && (this.effectiveDate == rhs.effectiveDate || this.effectiveDate != null && this.effectiveDate.equals(rhs.effectiveDate)) && (this.basedOn == rhs.basedOn || this.basedOn != null && this.basedOn.equals(rhs.basedOn)) && (this.processActivity == rhs.processActivity || this.processActivity != null && this.processActivity.equals(rhs.processActivity));
    }
}

