/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.justice.laa.crime.common.model.contribution;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import uk.gov.justice.laa.crime.common.model.common.ApiCrownCourtOutcome;
import uk.gov.justice.laa.crime.enums.CaseType;
import uk.gov.justice.laa.crime.enums.MagCourtOutcome;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"magCourtOutcome", "caseType", "crownCourtOutcome"})
public class ApiMaatCheckContributionRuleRequest {
    @JsonProperty(value="magCourtOutcome")
    @JsonPropertyDescription(value="Magistrate Court Outcome")
    @Valid
    private MagCourtOutcome magCourtOutcome;
    @JsonProperty(value="caseType")
    @JsonPropertyDescription(value="The case type")
    @Valid
    @NotNull
    private CaseType caseType;
    @JsonProperty(value="crownCourtOutcome")
    @JsonPropertyDescription(value="list of crown court outcome")
    @Valid
    private List<ApiCrownCourtOutcome> crownCourtOutcome = new ArrayList<ApiCrownCourtOutcome>();
    protected static final Object NOT_FOUND_VALUE = new Object();

    public ApiMaatCheckContributionRuleRequest() {
    }

    public ApiMaatCheckContributionRuleRequest(MagCourtOutcome magCourtOutcome, CaseType caseType, List<ApiCrownCourtOutcome> crownCourtOutcome) {
        this.magCourtOutcome = magCourtOutcome;
        this.caseType = caseType;
        this.crownCourtOutcome = crownCourtOutcome;
    }

    @JsonProperty(value="magCourtOutcome")
    public MagCourtOutcome getMagCourtOutcome() {
        return this.magCourtOutcome;
    }

    @JsonProperty(value="magCourtOutcome")
    public void setMagCourtOutcome(MagCourtOutcome magCourtOutcome) {
        this.magCourtOutcome = magCourtOutcome;
    }

    public ApiMaatCheckContributionRuleRequest withMagCourtOutcome(MagCourtOutcome magCourtOutcome) {
        this.magCourtOutcome = magCourtOutcome;
        return this;
    }

    @JsonProperty(value="caseType")
    public CaseType getCaseType() {
        return this.caseType;
    }

    @JsonProperty(value="caseType")
    public void setCaseType(CaseType caseType) {
        this.caseType = caseType;
    }

    public ApiMaatCheckContributionRuleRequest withCaseType(CaseType caseType) {
        this.caseType = caseType;
        return this;
    }

    @JsonProperty(value="crownCourtOutcome")
    public List<ApiCrownCourtOutcome> getCrownCourtOutcome() {
        return this.crownCourtOutcome;
    }

    @JsonProperty(value="crownCourtOutcome")
    public void setCrownCourtOutcome(List<ApiCrownCourtOutcome> crownCourtOutcome) {
        this.crownCourtOutcome = crownCourtOutcome;
    }

    public ApiMaatCheckContributionRuleRequest withCrownCourtOutcome(List<ApiCrownCourtOutcome> crownCourtOutcome) {
        this.crownCourtOutcome = crownCourtOutcome;
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("magCourtOutcome".equals(name)) {
            if (!(value instanceof MagCourtOutcome)) {
                throw new IllegalArgumentException("property \"magCourtOutcome\" is of type \"uk.gov.justice.laa.crime.enums.MagCourtOutcome\", but got " + value.getClass().toString());
            }
            this.setMagCourtOutcome((MagCourtOutcome)value);
            return true;
        }
        if ("caseType".equals(name)) {
            if (!(value instanceof CaseType)) {
                throw new IllegalArgumentException("property \"caseType\" is of type \"uk.gov.justice.laa.crime.enums.CaseType\", but got " + value.getClass().toString());
            }
            this.setCaseType((CaseType)value);
            return true;
        }
        if ("crownCourtOutcome".equals(name)) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("property \"crownCourtOutcome\" is of type \"java.util.List<uk.gov.justice.laa.crime.common.model.common.ApiCrownCourtOutcome>\", but got " + value.getClass().toString());
            }
            this.setCrownCourtOutcome((List)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("magCourtOutcome".equals(name)) {
            return this.getMagCourtOutcome();
        }
        if ("caseType".equals(name)) {
            return this.getCaseType();
        }
        if ("crownCourtOutcome".equals(name)) {
            return this.getCrownCourtOutcome();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        throw new IllegalArgumentException("property \"" + name + "\" is not defined");
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
    }

    public ApiMaatCheckContributionRuleRequest with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            throw new IllegalArgumentException("property \"" + name + "\" is not defined");
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ApiMaatCheckContributionRuleRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("magCourtOutcome");
        sb.append('=');
        sb.append((Object)(this.magCourtOutcome == null ? "<null>" : this.magCourtOutcome));
        sb.append(',');
        sb.append("caseType");
        sb.append('=');
        sb.append((Object)(this.caseType == null ? "<null>" : this.caseType));
        sb.append(',');
        sb.append("crownCourtOutcome");
        sb.append('=');
        sb.append(this.crownCourtOutcome == null ? "<null>" : this.crownCourtOutcome);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.crownCourtOutcome == null ? 0 : this.crownCourtOutcome.hashCode());
        result = result * 31 + (this.magCourtOutcome == null ? 0 : this.magCourtOutcome.hashCode());
        result = result * 31 + (this.caseType == null ? 0 : this.caseType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ApiMaatCheckContributionRuleRequest)) {
            return false;
        }
        ApiMaatCheckContributionRuleRequest rhs = (ApiMaatCheckContributionRuleRequest)other;
        return (this.crownCourtOutcome == rhs.crownCourtOutcome || this.crownCourtOutcome != null && this.crownCourtOutcome.equals(rhs.crownCourtOutcome)) && (this.magCourtOutcome == rhs.magCourtOutcome || this.magCourtOutcome != null && this.magCourtOutcome.equals((Object)rhs.magCourtOutcome)) && (this.caseType == rhs.caseType || this.caseType != null && this.caseType.equals((Object)rhs.caseType));
    }
}

